package rozdzial31;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

 public class Listing31_15 {
    public static void main(String[] args) {
        try {
            URI uri = new URI("http://jdk.java.net/16/");
            //URI uri = new URI("https://istis.pl/");
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest req = HttpRequest.newBuilder(uri)
                    .method("HEAD", HttpRequest.BodyPublishers.noBody())
                    .version(HttpClient.Version.HTTP_2)
                    .build();
            client.sendAsync(req, HttpResponse.BodyHandlers.ofString())
                    .thenApply(HttpResponse::body)
                    .thenAccept(System.out::println)
                    .join();
            System.out.println("HTTP żądania: " + req.version());
            HttpResponse<?> res =
                    client.send(req, HttpResponse.BodyHandlers.discarding());
            System.out.println("DANE ODPOWIEDZI");
            System.out.println("HTTP odpowiedzi: " + res.version());
            System.out.println("Nagłówki odpowiedzi: ");
            res.headers()
                    .map()
                    .entrySet()
                    .forEach(System.out::println);
        } catch (URISyntaxException | InterruptedException | IOException e) {
            e.printStackTrace();
        }
    }
}
