package rozdzial31;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.VBox;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.util.Callback;

import java.net.URL;
import java.util.Optional;

public class Listing31_06 extends Application {

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            WebView wv = new WebView();
            WebEngine we = wv.getEngine();
            URL url = this.getClass().getClassLoader()
                    .getResource("resources/html/prompt.html");
            if (url != null) {
                we.load(url.toExternalForm());
            }
            we.setPromptHandler(new Callback<PromptData, String>() {
                @Override
                public String call(PromptData param) {
                    TextInputDialog dialog = new TextInputDialog(
                            param.getDefaultValue());
                    dialog.setHeaderText(param.getMessage());
                    dialog.initOwner(stage);
                    Optional<String> op = dialog.showAndWait();
                    return op.orElseGet(dialog::getDefaultValue);
                }
            });
            root.getChildren().add(wv);
            Scene scene = new Scene(root, 560, 360);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
