package rozdzial24;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.image.*;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class Listing24_17 extends Application {
    BufferedInputStream bis;
    FileInputStream is;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            is = new FileInputStream(new File("src/rozdzial24/kwiatek3.jpg"));
            bis = new BufferedInputStream(is);
            Image image = new Image(bis);
            ImageView imageView = new ImageView(image);
            PixelReader pr = image.getPixelReader();
            int w = (int) image.getWidth();
            int h = (int) image.getHeight();
            WritableImage image1 = new WritableImage(pr, w, h);
            PixelWriter pw = image1.getPixelWriter();
            for (int i = 0; i < w; i++) {
                for (int j = 0; j < h; j++) {
                    pw.setColor(i, j, IOUtil.gray(pr.getColor(i, j)));
                }
            }
            ImageView imageView1 = new ImageView(image1);
            HBox root = new HBox();
            root.getChildren().addAll(imageView, imageView1);
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        if (bis != null) {
            try {
                bis.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (is != null) {
            try {
                is.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
