package rozdzial22;

import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.geometry.Point3D;
import javafx.scene.Scene;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;

public class Listing22_27 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void init() {
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            TreeItem<String> troot = Systematyka.wstawDane();
            TreeView<String> syst = new TreeView<>();
            EventHandler<MouseEvent> mouseHandler = e -> {
                System.out.print("Zaszło zdarzenie: "
                        + e.getEventType().getName() + " w punkcie: ");
                Point3D pr = e.getPickResult().getIntersectedPoint();
                System.out.println(pr);
            };
            syst.setCellFactory(
                    new Callback<>() {
                        @Override
                        public TreeCell<String> call(TreeView<String> param) {
                            TreeCell<String> tc = new TreeCell<>() {
                                @Override
                                public void updateItem(String item,
                                                       boolean empty) {
                                    super.updateItem(item, empty);
                                    if (empty) {
                                        setText(null);
                                        setGraphic(null);
                                    } else {
                                        String v = getTreeItem().getValue();
                                        setText(v);
                                    }
                                }
                            };
                            tc.addEventHandler(MouseEvent.MOUSE_PRESSED,
                                    mouseHandler);
                            return tc;
                        }
                    });
            syst.setRoot(troot);
            syst.setPrefHeight(500);
            root.getChildren().add(syst);
            Scene scene = new Scene(root, 400, 500);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
    }
}
