package rozdzial21;

import javafx.application.Application;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Scene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.FileChooser.ExtensionFilter;
import javafx.stage.Stage;

import javax.imageio.ImageIO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Listing21_22 extends Application {
    private File selectedFile;
    private File savedFile;
    private Image image;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            ImageView iv = new ImageView();
            FileChooser fileChooser = new FileChooser();
            Menu menuPlik = new Menu("Plik");
            MenuItem openItem = new MenuItem("Otwórz");
            openItem.setOnAction(e -> {
                fileChooser.setTitle("Wczytaj plik");
                fileChooser.getExtensionFilters()
                        .addAll(new ExtensionFilter("Image Files", "*.png",
                                "*.jpg", "*.gif"));
                selectedFile = fileChooser.showOpenDialog(stage);
                if (selectedFile == null) {
                    return;
                }
                try {
                    image = new Image(new FileInputStream(selectedFile));
                } catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                iv.setImage(image);
            });
            MenuItem saveItem = new MenuItem("Zapisz");
            saveItem.setOnAction(e -> {
                fileChooser.setTitle("Zapisz plik");
                savedFile = fileChooser.showSaveDialog(stage);
                if (savedFile != null) {
                    try {
                        ImageIO.write(SwingFXUtils.fromFXImage(image, null),
                                "png", savedFile);
                    } catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            });
            menuPlik.getItems().addAll(openItem, saveItem);
            MenuBar menuBar = new MenuBar();
            menuBar.getMenus().addAll(menuPlik);
            //
            root.getChildren().addAll(menuBar, iv);
            Scene scene = new Scene(root, 300, 200);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
