package rozdzial18;

import javafx.application.Application;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class Listing18_22 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            ColorStringConverter csc = new ColorStringConverter();
            Label label = new Label("Wybierz najładniejszy kolor: ");
            ObservableList<Color> ol = FXCollections.observableArrayList(
                    Color.AQUA, Color.SKYBLUE, Color.VIOLET, Color.BLUE,
                    Color.TURQUOISE);
            ListView<Color> lv1 = new ListView<>();
            lv1.setItems(ol);
            lv1.setCellFactory(param -> new ColorCell());
            ReadOnlyObjectProperty<Color> ind = lv1.getSelectionModel()
                    .selectedItemProperty();
            ind.addListener((observable, oldValue, newValue) -> System.out.println("Aktualna wartość selected to "
                    + csc.toString(newValue)));
            root.getChildren().addAll(label, lv1);
            Scene scene = new Scene(root, 200, 200);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
