package rozdzial14;

import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.stage.Stage;
import javafx.util.Duration;

public class Listing14_13 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Pane root = new Pane();
            Circle circle = new Circle(5, Color.DEEPSKYBLUE);
            circle.setCenterX(0);
            circle.setCenterY(100);
            Line line = new Line(0, 100, 100, 0);
            line.setStrokeWidth(1);
            line.setStroke(Color.LIGHTGRAY);
            root.getChildren().addAll(line, circle);
            Scene scene = new Scene(root, 100, 100);
            stage.setScene(scene);
            stage.show();
            //-
            KeyValue kv1 = new KeyValue(circle.centerXProperty(), 0,
                    Interpolator.LINEAR);
            KeyValue kv2 = new KeyValue(circle.centerYProperty(), 100,
                    new Listing14_12());
            KeyValue[] val1 = {kv1, kv2};
            KeyFrame kf1 = new KeyFrame(Duration.millis(0), val1);
            //-
            KeyValue kv3 = new KeyValue(circle.centerXProperty(), 100,
                    Interpolator.LINEAR);
            KeyValue kv4 = new KeyValue(circle.centerYProperty(), 0,
                    new Listing14_12());
            KeyValue[] val2 = {kv3, kv4};
            KeyFrame kf2 = new KeyFrame(Duration.millis(4500), val2);
            //-
            Timeline timeline = new Timeline();
            timeline.getKeyFrames().addAll(kf1, kf2);
            timeline.setCycleCount(1);
            timeline.play();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
