package rozdzial13;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.ImageInput;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

import java.io.File;
import java.io.FileInputStream;

public class Listing13_14 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Pane root = new Pane();
            //-
            Image image1 = new Image(
                    new FileInputStream(new File("src/rozdzial13/pies.jpg")));
            ImageView imageView1 = new ImageView(image1);
            imageView1.setFitWidth(300);
            imageView1.setFitHeight(285);
            imageView1.setPreserveRatio(true);
            ImageInput i1 = new ImageInput(image1, 220, 10);
            //-
            Image image2 = new Image(
                    new FileInputStream(new File("src/rozdzial13/fire.jpg")));
            ImageView imageView2 = new ImageView(image2);
            imageView2.setFitWidth(300);
            imageView2.setFitHeight(225);
            imageView2.setPreserveRatio(true);
            ImageInput i2 = new ImageInput(image2, 350, 100);
            //efekt
            Blend ds = new Blend();
            ds.setTopInput(i2);
            ds.setBottomInput(i1);
            ds.setMode(BlendMode.MULTIPLY);
            //rectangle
            Rectangle rect = new Rectangle(1, 1);
            rect.setEffect(ds);
            //slider 1
            Slider oxslider = new Slider(0.0, 1.0, 0.75);
            oxslider.setLayoutX(60);
            oxslider.setLayoutY(20);
            oxslider.setMajorTickUnit(0.1);
            oxslider.setShowTickLabels(true);
            oxslider.setShowTickMarks(true);
            ds.opacityProperty().bind(oxslider.valueProperty());
            Label oxslabel = new Label("opacity: ");
            oxslabel.setLabelFor(oxslider);
            oxslabel.setLayoutX(20);
            oxslabel.setLayoutY(20);
            //-
            ComboBox<BlendMode> cbox = new ComboBox<>();
            cbox.getItems().addAll(BlendMode.values());
            cbox.setLayoutX(80);
            cbox.setLayoutY(100);
            cbox.setValue(ds.getMode());
            ds.modeProperty().bind(cbox.valueProperty());
            Label cb1label = new Label("BlendMode: ");
            cb1label.setLabelFor(cbox);
            cb1label.setLayoutX(20);
            cb1label.setLayoutY(100);
            //
            root.getChildren().addAll(oxslabel, oxslider, cb1label, cbox, rect);
            Scene scene = new Scene(root, 680, 370);
            stage.setScene(scene);
            stage.setTitle("Blend");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
