package rozdzial11;

import javafx.application.Application;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.scene.Group;
import javafx.scene.PointLight;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Sphere;
import javafx.scene.transform.Translate;
import javafx.stage.Stage;

public class Listing11_11 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        boolean supp = Platform.isSupported(ConditionalFeature.SCENE3D);
        try {
            if (supp) {
                PhongMaterial pm = new PhongMaterial(Color.CADETBLUE);
                pm.setSpecularColor(Color.LIGHTBLUE);
                pm.setSpecularPower(32);
                PointLight pl = new PointLight(Color.WHITE);
                Group group = new Group();
                Sphere sphere = new Sphere(75);
                sphere.setMaterial(pm);
                Translate trans1 = new Translate(150, 150, 100);
                sphere.getTransforms().add(trans1);
                group.getChildren().addAll(sphere, pl);
                Scene sc = new Scene(group, 300, 300);
                stage.setScene(sc);
            } else {
                StackPane root = new StackPane();
                Label label = new Label("Brak obsługi 3D");
                root.getChildren().add(label);
                Scene sc = new Scene(root, 400, 400);
                stage.setScene(sc);
            }
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
