package rozdzial11;

import javafx.application.Application;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.scene.*;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Box;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.Sphere;
import javafx.scene.transform.Translate;
import javafx.stage.Stage;

public class Listing11_07 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        boolean supp = Platform.isSupported(ConditionalFeature.SCENE3D);
        try {
            if (supp) {
                Group group = new Group();
                Sphere sphere = new Sphere(50);
                Translate trans1 = new Translate(-100, 0, 100);
                sphere.getTransforms().add(trans1);
                Cylinder cyli = new Cylinder(30, 100);
                Translate trans2 = new Translate(20, 0, 100);
                cyli.getTransforms().add(trans2);
                Box box = new Box(100, 100, 100);
                Translate trans3 = new Translate(140, 0, 100);
                box.getTransforms().add(trans3);
                PointLight al = new PointLight();
                PerspectiveCamera pc = new PerspectiveCamera(true);
                group.getChildren().addAll(sphere, box, cyli, al);
                Scene scene = new Scene(group, 500, 200, true,
                        SceneAntialiasing.BALANCED);
                pc.setNearClip(0.1);
                pc.setFarClip(100.0);
                pc.setFieldOfView(30);
                scene.setCamera(pc);
                stage.setScene(scene);
            } else {
                StackPane root = new StackPane();
                Label label = new Label("Brak obsługi 3D");
                root.getChildren().add(label);
                Scene sc = new Scene(root, 300, 200);
                stage.setScene(sc);
            }
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
