/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package usluga;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

/**
 *
 * @author apple
 */
@Path("ogloszenie")
public class OgloszenieFacadeREST extends AbstractFacade<Ogloszenie> {
    protected static EntityManagerFactory emf = Persistence.createEntityManagerFactory("SerwerOgloszenPU");
    private EntityManager em = emf.createEntityManager();

    public OgloszenieFacadeREST() {
        super(Ogloszenie.class);
    }

    @POST
    @Override
    @Consumes({"application/xml", "application/json"})
    public void create(Ogloszenie entity) {
        em.getTransaction().begin();
        entity.setId(null);
        super.create(entity);
        em.getTransaction().commit();
    }

    @PUT
    @Path("{id}")
    @Consumes({"application/xml", "application/json"})
    public void edit(@PathParam("id") Integer id, Ogloszenie entity) {
        em.getTransaction().begin();
        super.edit(entity);
        em.getTransaction().commit();
    }

    @DELETE
    @Path("{id}")
    public void remove(@PathParam("id") Integer id) {
        em.getTransaction().begin();
        super.remove(super.find(id));
        em.getTransaction().commit();
    }

    @GET
    @Path("{id}")
    @Produces({"application/json"})
    public Ogloszenie find(@PathParam("id") Integer id) {
        return super.find(id);
    }

    @GET
    @Override
    @Produces({"application/json"})
    public List<Ogloszenie> findAll() {
        List<Ogloszenie> lista = super.findAll();
        return lista;
    }

    @GET
    @Path("{from}/{to}")
    @Produces({"application/json"})
    public List<Ogloszenie> findRange(@PathParam("from") Integer from, @PathParam("to") Integer to) {
        return super.findRange(new int[]{from, to});
    }

    @GET
    @Path("count")
    @Produces("text/plain")
    public String countREST() {
        return String.valueOf(super.count());
    }

    @Override
    protected EntityManager getEntityManager() {
        return em;
    }
    
}
