/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.path;

import java.io.Serializable;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.PathSource;
import org.hibernate.ejb.criteria.path.AbstractPathImpl;

public class SingularAttributePath<X>
extends AbstractPathImpl<X>
implements Serializable {
    private final SingularAttribute<?, X> attribute;
    private final ManagedType<X> managedType;

    public SingularAttributePath(CriteriaBuilderImpl criteriaBuilder, Class<X> javaType, PathSource pathSource, SingularAttribute<?, X> attribute) {
        super(criteriaBuilder, javaType, pathSource);
        this.attribute = attribute;
        this.managedType = this.resolveManagedType(attribute);
    }

    private ManagedType<X> resolveManagedType(SingularAttribute<?, X> attribute) {
        if (Attribute.PersistentAttributeType.BASIC == attribute.getPersistentAttributeType()) {
            return null;
        }
        if (Attribute.PersistentAttributeType.EMBEDDED == attribute.getPersistentAttributeType()) {
            return (EmbeddableType)attribute.getType();
        }
        return (IdentifiableType)attribute.getType();
    }

    @Override
    public SingularAttribute<?, X> getAttribute() {
        return this.attribute;
    }

    public Bindable<X> getModel() {
        return this.getAttribute();
    }

    @Override
    protected boolean canBeDereferenced() {
        return this.managedType != null;
    }

    @Override
    protected Attribute locateAttributeInternal(String attributeName) {
        Attribute attribute = this.managedType.getAttribute(attributeName);
        if (attribute == null) {
            throw new IllegalArgumentException("Could not resolve attribute named " + attributeName);
        }
        return attribute;
    }
}

