/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.util.Hashtable;
import org.apache.derby.impl.drda.DDMWriter;
import org.apache.derby.impl.drda.DRDAConnThread;
import org.apache.derby.impl.drda.DRDAProtocolExceptionInfo;
import org.apache.derby.impl.drda.NetworkServerControlImpl;

class DRDAProtocolException
extends Exception {
    protected static final int NO_ASSOC_ERRCD = 0;
    protected static final int NO_CODPNT_ARG = 0;
    private DRDAConnThread agent;
    private int correlationID;
    private byte[] crrtkn;
    private int codpntArg;
    private DRDAProtocolExceptionInfo exceptionInfo;
    private int errorCodePoint;
    private int svrcod;
    private int errcd;
    private String messageid;
    private String rdbnam;
    private String srvdgn;
    private Object[] messageArgs;
    private String msg;
    private static Hashtable<String, DRDAProtocolExceptionInfo> errorInfoTable;
    protected static String DRDA_Proto_CMDCHKRM;
    protected static String DRDA_Proto_CMDNSPRM;
    protected static String DRDA_Proto_DTAMCHRM;
    protected static String DRDA_Proto_OBJNSPRM;
    protected static String DRDA_Proto_PKGBNARM;
    protected static String DRDA_Proto_PRCCNVRM;
    protected static String DRDA_Proto_PRMNSRM;
    protected static String DRDA_Proto_SYNTAXRM;
    protected static String DRDA_Proto_VALNSPRM;
    protected static String DRDA_Proto_MGRLVLRM;
    protected static String DRDA_Proto_RDBNFNRM;
    protected static String DRDA_Disconnect;
    protected static String DRDA_AgentError;
    protected static String DRDA_Timeout;
    protected static String DRDA_InvalidClient;

    DRDAProtocolException(String string, DRDAConnThread dRDAConnThread, int n, int n2, Object[] objectArray) {
        Object object;
        boolean bl = false;
        this.exceptionInfo = errorInfoTable.get(string);
        if (dRDAConnThread != null) {
            this.correlationID = dRDAConnThread.getCorrelationID();
            this.crrtkn = dRDAConnThread.getCrrtkn();
        }
        this.codpntArg = n;
        this.errorCodePoint = this.exceptionInfo.errorCodePoint;
        this.errcd = n2;
        this.messageid = string;
        if (string.equals(DRDA_AgentError)) {
            this.svrcod = (Integer)objectArray[0];
            this.rdbnam = (String)objectArray[1];
            object = (String)objectArray[2];
            this.msg = "Execution failed because of Permanent Agent Error: SVRCOD = " + Integer.toHexString(this.svrcod) + "; RDBNAM = " + this.rdbnam + "; diagnostic msg = " + (String)object;
            bl = true;
        } else if (string.equals(DRDA_Proto_RDBNFNRM)) {
            this.svrcod = this.exceptionInfo.svrcod;
            this.rdbnam = (String)objectArray[0];
            this.msg = "Execution failed because of Distributed Protocol Error:  " + this.messageid + "; RDBNAM = " + this.rdbnam;
        } else {
            this.svrcod = this.exceptionInfo.svrcod;
            this.msg = "Execution failed because of a Distributed Protocol Error:  " + this.messageid + "; CODPNT arg  = " + Integer.toHexString(n) + "; Error Code Value = " + Integer.toHexString(n2);
            if (string.equals(DRDA_Proto_SYNTAXRM)) {
                this.msg = this.msg + ". Plaintext connection attempt from an SSL enabled client?";
            }
        }
        if (!bl && objectArray != null) {
            this.messageArgs = objectArray;
            for (int i = 0; i < objectArray.length; ++i) {
                this.msg = string.equals(DRDA_Proto_MGRLVLRM) ? this.msg + "," + Integer.toHexString((Integer)objectArray[i]) : this.msg + "," + objectArray[i];
            }
        }
        if (!this.isDisconnectException()) {
            DRDAConnThread.println2Log(dRDAConnThread.getDbName(), dRDAConnThread.getSession().drdaID, this.msg);
            object = dRDAConnThread.getServer();
            ((NetworkServerControlImpl)object).consoleExceptionPrintTrace(this);
        }
    }

    DRDAProtocolException(String string, DRDAConnThread dRDAConnThread, int n, int n2) {
        this(string, dRDAConnThread, n, n2, null);
    }

    protected static DRDAProtocolException newDisconnectException(DRDAConnThread dRDAConnThread, Object[] objectArray) {
        return new DRDAProtocolException(DRDA_Disconnect, dRDAConnThread, 0, 0, objectArray);
    }

    protected static DRDAProtocolException newAgentError(DRDAConnThread dRDAConnThread, int n, String string, String string2) {
        Object[] objectArray = new Object[]{n, string, string2};
        return new DRDAProtocolException(DRDA_AgentError, dRDAConnThread, 0, 0, objectArray);
    }

    protected final boolean isDisconnectException() {
        return this.errorCodePoint == 0;
    }

    protected void write(DDMWriter dDMWriter) {
        dDMWriter.createDssReply();
        dDMWriter.startDdm(this.errorCodePoint);
        dDMWriter.writeScalar2Bytes(4425, this.svrcod);
        if (this.exceptionInfo.sendsCodpntArg) {
            dDMWriter.writeScalar2Bytes(12, this.codpntArg);
        }
        if (this.exceptionInfo.errCdCodePoint != 0) {
            dDMWriter.writeScalar1Byte(this.exceptionInfo.errCdCodePoint, this.errcd);
        }
        if (this.rdbnam != null && this.agent != null) {
            try {
                this.agent.writeRDBNAM(this.rdbnam);
            }
            catch (DRDAProtocolException dRDAProtocolException) {
                // empty catch block
            }
        }
        if (this.errorCodePoint == 4624) {
            dDMWriter.startDdm(5124);
            for (int i = 0; i < this.messageArgs.length; i += 2) {
                dDMWriter.writeNetworkShort((Integer)this.messageArgs[i]);
                dDMWriter.writeNetworkShort((Integer)this.messageArgs[i + 1]);
            }
            dDMWriter.endDdm();
        }
        dDMWriter.endDdmAndDss();
    }

    public String getMessage() {
        return this.msg;
    }

    static {
        DRDA_Proto_CMDCHKRM = "DRDA_Proto_CMDCHKRM";
        DRDA_Proto_CMDNSPRM = "DRDA_Proto_CMDNSPRM";
        DRDA_Proto_DTAMCHRM = "DRDA_Proto_DTAMCHRM";
        DRDA_Proto_OBJNSPRM = "DRDA_Proto_OBJNSPRM";
        DRDA_Proto_PKGBNARM = "DRDA_Proto_PKGBNARM";
        DRDA_Proto_PRCCNVRM = "DRDA_Proto_PRCCNVRM";
        DRDA_Proto_PRMNSRM = "DRDA_Proto_PRMNSPRM";
        DRDA_Proto_SYNTAXRM = "DRDA_Proto_SYNTAXRM";
        DRDA_Proto_VALNSPRM = "DRDA_Proto_VALNSPRM";
        DRDA_Proto_MGRLVLRM = "DRDA_Proto_MGRLVLRM";
        DRDA_Proto_RDBNFNRM = "DRDA_Proto_RDBNFNRM";
        DRDA_Disconnect = "DRDA_Disconnect";
        DRDA_AgentError = "DRDA_AgentError";
        DRDA_Timeout = "DRDA_Timeout";
        DRDA_InvalidClient = "DRDA_InvalidClient";
        errorInfoTable = new Hashtable();
        errorInfoTable.put(DRDA_Proto_CMDCHKRM, new DRDAProtocolExceptionInfo(4692, 8, 0, false));
        errorInfoTable.put(DRDA_Proto_CMDNSPRM, new DRDAProtocolExceptionInfo(4688, 8, 0, true));
        errorInfoTable.put(DRDA_Proto_DTAMCHRM, new DRDAProtocolExceptionInfo(8718, 8, 0, false));
        errorInfoTable.put(DRDA_Proto_OBJNSPRM, new DRDAProtocolExceptionInfo(4691, 8, 0, true));
        errorInfoTable.put(DRDA_Proto_PKGBNARM, new DRDAProtocolExceptionInfo(8710, 8, 0, false));
        errorInfoTable.put(DRDA_Proto_PRCCNVRM, new DRDAProtocolExceptionInfo(4677, 8, 4415, false));
        errorInfoTable.put(DRDA_Proto_SYNTAXRM, new DRDAProtocolExceptionInfo(4684, 8, 4426, true));
        errorInfoTable.put(DRDA_Proto_VALNSPRM, new DRDAProtocolExceptionInfo(4690, 8, 0, true));
        errorInfoTable.put(DRDA_Proto_MGRLVLRM, new DRDAProtocolExceptionInfo(4624, 8, 0, false));
        errorInfoTable.put(DRDA_Proto_RDBNFNRM, new DRDAProtocolExceptionInfo(8721, 8, 0, false));
        errorInfoTable.put(DRDA_Disconnect, new DRDAProtocolExceptionInfo(0, 0, 0, false));
        errorInfoTable.put(DRDA_AgentError, new DRDAProtocolExceptionInfo(4658, 64, 0, false));
        errorInfoTable.put(DRDA_Timeout, new DRDAProtocolExceptionInfo(0, 0, 0, false));
    }
}

