/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlCode;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.shared.common.i18n.MessageUtil;

public class Decimal {
    public static final int PACKED_DECIMAL = 48;
    private static final MessageUtil msgutil = SqlException.getMessageUtil();
    private static final int[][] tenRadixMagnitude = new int[][]{{1000000000}, {232830643, -1486618624}, {54210108, -1613725636, -402653184}};

    private Decimal() {
    }

    private static final int packedNybblesToInt(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n2 / 2;
        if (n2 % 2 != 0) {
            n4 += byArray[n + n5] & 0xF;
            ++n5;
        }
        int n6 = n2 + n3 - 1;
        while (n5 < (n6 + 1) / 2) {
            n4 = n4 * 10 + ((byArray[n + n5] & 0xF0) >>> 4);
            n4 = n4 * 10 + (byArray[n + n5] & 0xF);
            ++n5;
        }
        if (n6 % 2 == 0) {
            n4 = n4 * 10 + ((byArray[n + n5] & 0xF0) >>> 4);
        }
        return n4;
    }

    private static final long packedNybblesToLong(byte[] byArray, int n, int n2, int n3) {
        long l = 0L;
        int n4 = n2 / 2;
        if (n2 % 2 != 0) {
            l += (long)(byArray[n + n4] & 0xF);
            ++n4;
        }
        int n5 = n2 + n3 - 1;
        while (n4 < (n5 + 1) / 2) {
            l = l * 10L + (long)((byArray[n + n4] & 0xF0) >>> 4);
            l = l * 10L + (long)(byArray[n + n4] & 0xF);
            ++n4;
        }
        if (n5 % 2 == 0) {
            l = l * 10L + (long)((byArray[n + n4] & 0xF0) >>> 4);
        }
        return l;
    }

    private static final int[] computeMagnitude(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        nArray2[n - 1] = nArray[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            int n2 = 0;
            int n3 = tenRadixMagnitude[i].length - 1;
            int n4 = n - 1;
            while (n3 >= 0) {
                long l = ((long)nArray[n - 2 - i] & 0xFFFFFFFFL) * ((long)tenRadixMagnitude[i][n3] & 0xFFFFFFFFL) + ((long)nArray2[n4] & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL);
                n2 = (int)(l >>> 32);
                nArray2[n4] = (int)(l & 0xFFFFFFFFL);
                --n3;
                --n4;
            }
            nArray2[n4] = n2;
        }
        return nArray2;
    }

    public static final BigDecimal getBigDecimal(byte[] byArray, int n, int n2, int n3) throws UnsupportedEncodingException {
        int n4 = n2 / 2 + 1;
        int n5 = (byArray[n + n4 - 1] & 0xF) == 13 ? -1 : 1;
        if (n2 <= 18) {
            long l = Decimal.packedNybblesToLong(byArray, n, 0, n4 * 2 - 1);
            if (n5 < 0) {
                l = -l;
            }
            return BigDecimal.valueOf(l, n3);
        }
        if (n2 <= 27) {
            int n6 = Decimal.packedNybblesToInt(byArray, n, (n4 - 5) * 2, 9);
            int n7 = Decimal.packedNybblesToInt(byArray, n, (n4 - 10) * 2 + 1, 9);
            int n8 = Decimal.packedNybblesToInt(byArray, n, 0, (n4 - 10) * 2 + 1);
            int[] nArray = Decimal.computeMagnitude(new int[]{n8, n7, n6});
            byte[] byArray2 = new byte[]{(byte)(nArray[0] >>> 24), (byte)(nArray[0] >>> 16), (byte)(nArray[0] >>> 8), (byte)nArray[0], (byte)(nArray[1] >>> 24), (byte)(nArray[1] >>> 16), (byte)(nArray[1] >>> 8), (byte)nArray[1], (byte)(nArray[2] >>> 24), (byte)(nArray[2] >>> 16), (byte)(nArray[2] >>> 8), (byte)nArray[2]};
            return new BigDecimal(new BigInteger(n5, byArray2), n3);
        }
        if (n2 <= 31) {
            int n9 = Decimal.packedNybblesToInt(byArray, n, (n4 - 5) * 2, 9);
            int n10 = Decimal.packedNybblesToInt(byArray, n, (n4 - 10) * 2 + 1, 9);
            int n11 = Decimal.packedNybblesToInt(byArray, n, (n4 - 14) * 2, 9);
            int n12 = Decimal.packedNybblesToInt(byArray, n, 0, (n4 - 14) * 2);
            int[] nArray = Decimal.computeMagnitude(new int[]{n12, n11, n10, n9});
            byte[] byArray3 = new byte[]{(byte)(nArray[0] >>> 24), (byte)(nArray[0] >>> 16), (byte)(nArray[0] >>> 8), (byte)nArray[0], (byte)(nArray[1] >>> 24), (byte)(nArray[1] >>> 16), (byte)(nArray[1] >>> 8), (byte)nArray[1], (byte)(nArray[2] >>> 24), (byte)(nArray[2] >>> 16), (byte)(nArray[2] >>> 8), (byte)nArray[2], (byte)(nArray[3] >>> 24), (byte)(nArray[3] >>> 16), (byte)(nArray[3] >>> 8), (byte)nArray[3]};
            return new BigDecimal(new BigInteger(n5, byArray3), n3);
        }
        throw new IllegalArgumentException(msgutil.getTextMessage("22003.S.2"));
    }

    public static final double getDouble(byte[] byArray, int n, int n2, int n3) throws UnsupportedEncodingException {
        int n4 = n2 / 2 + 1;
        int n5 = (byArray[n + n4 - 1] & 0xF) == 13 ? -1 : 1;
        if (n2 <= 9) {
            int n6 = Decimal.packedNybblesToInt(byArray, n, 0, n4 * 2 - 1);
            return (double)(n5 * n6) / Math.pow(10.0, n3);
        }
        if (n2 <= 18) {
            long l = Decimal.packedNybblesToLong(byArray, n, 0, n4 * 2 - 1);
            return (double)((long)n5 * l) / Math.pow(10.0, n3);
        }
        if (n2 <= 27) {
            int n7 = Decimal.packedNybblesToInt(byArray, n, (n4 - 5) * 2, 9);
            int n8 = Decimal.packedNybblesToInt(byArray, n, (n4 - 10) * 2 + 1, 9);
            int n9 = Decimal.packedNybblesToInt(byArray, n, 0, (n4 - 10) * 2 + 1);
            return (double)n5 * ((double)n7 / Math.pow(10.0, n3) + (double)n8 * Math.pow(10.0, 9 - n3) + (double)n9 * Math.pow(10.0, 18 - n3));
        }
        if (n2 <= 31) {
            int n10 = Decimal.packedNybblesToInt(byArray, n, (n4 - 5) * 2, 9);
            int n11 = Decimal.packedNybblesToInt(byArray, n, (n4 - 10) * 2 + 1, 9);
            int n12 = Decimal.packedNybblesToInt(byArray, n, (n4 - 14) * 2, 9);
            int n13 = Decimal.packedNybblesToInt(byArray, n, 0, (n4 - 14) * 2);
            return (double)n5 * ((double)n10 / Math.pow(10.0, n3) + (double)n11 * Math.pow(10.0, 9 - n3) + (double)n12 * Math.pow(10.0, 18 - n3) + (double)n13 * Math.pow(10.0, 27 - n3));
        }
        throw new IllegalArgumentException(msgutil.getTextMessage("22003.S.2"));
    }

    public static final long getLong(byte[] byArray, int n, int n2, int n3) throws UnsupportedEncodingException {
        if (n2 > 31) {
            throw new IllegalArgumentException(msgutil.getTextMessage("22003.S.2"));
        }
        int n4 = n2 / 2 + 1;
        int n5 = (byArray[n + n4 - 1] & 0xF) == 13 ? -1 : 1;
        if (n2 - n3 <= 18) {
            int n6 = n4 * 2 - 1 - n3;
            return (long)n5 * Decimal.packedNybblesToLong(byArray, n, 0, n6);
        }
        BigDecimal bigDecimal = new BigDecimal(Decimal.getBigDecimal(byArray, n, n2, n3).toBigInteger());
        return bigDecimal.longValueExact();
    }

    public static final int bigDecimalToPackedDecimalBytes(byte[] byArray, int n, BigDecimal bigDecimal, int n2, int n3) throws SqlException {
        int n4;
        int n5;
        if (n2 > 31) {
            throw new SqlException(null, new ClientMessageId("22003.S.2"));
        }
        String string = bigDecimal.unscaledValue().abs().toString();
        int n6 = string.length();
        if (n6 > 31) {
            throw new SqlException(null, new ClientMessageId("22003"), (Object)"packed decimal", new SqlCode(-405));
        }
        int n7 = bigDecimal.scale();
        int n8 = n6 - n7;
        if (n8 > 0 && !string.equals("0") && n8 > (n5 = n2 - n3)) {
            throw new SqlException(null, new ClientMessageId("22003.S.3"), (Object)bigDecimal.toString(), (Object)"packed decimal", new SqlCode(-413));
        }
        n5 = 48;
        int n9 = n2 - 1;
        if (n7 >= n3) {
            n4 = n6 - 1 - (n7 - n3);
            byArray[n + (n9 + 1) / 2] = n4 < 0 ? (byte)(bigDecimal.signum() >= 0 ? 12 : 13) : (byte)((string.charAt(n4) - n5 << 4) + (bigDecimal.signum() >= 0 ? 12 : 13));
            n9 -= 2;
            n4 -= 2;
        } else {
            n4 = n3 - n7 - 1;
            byArray[n + (n9 + 1) / 2] = (byte)(bigDecimal.signum() >= 0 ? 12 : 13);
            n9 -= 2;
            n4 -= 2;
            while (n4 >= 0) {
                byArray[n + (n9 + 1) / 2] = 0;
                n9 -= 2;
                n4 -= 2;
            }
            if (n4 == -1) {
                byArray[n + (n9 + 1) / 2] = (byte)(string.charAt(n6 - 1) - n5 << 4);
                n9 -= 2;
                n4 = n6 - 3;
            } else {
                n4 = n6 - 2;
            }
        }
        while (n4 >= 0) {
            byArray[n + (n9 + 1) / 2] = (byte)((string.charAt(n4) - n5 << 4) + (string.charAt(n4 + 1) - n5));
            n9 -= 2;
            n4 -= 2;
        }
        if (n4 == -1) {
            byArray[n + (n9 + 1) / 2] = (byte)(string.charAt(0) - n5);
            n9 -= 2;
        }
        while (n9 >= -1) {
            byArray[n + (n9 + 1) / 2] = 0;
            n9 -= 2;
        }
        return n2 / 2 + 1;
    }
}

