/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;

public final class StaticClassFieldReferenceNode
extends JavaValueNode {
    private String fieldName;
    private String javaClassName;
    private boolean classNameDelimitedIdentifier;
    private Member field;

    public void init(Object object, Object object2, Object object3) {
        this.fieldName = (String)object2;
        this.javaClassName = (String)object;
        this.classNameDelimitedIdentifier = (Boolean)object3;
    }

    public JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List list) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        if ((this.getCompilerContext().getReliability() & 0x400) != 0 || !this.javaClassName.startsWith("java.sql.")) {
            throw StandardException.newException("42X01", this.javaClassName + "::" + this.fieldName);
        }
        this.verifyClassExist(this.javaClassName);
        this.field = classInspector.findPublicField(this.javaClassName, this.fieldName, true);
        this.setJavaTypeName(classInspector.getType(this.field));
        return this;
    }

    public void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) {
        return true;
    }

    public JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        return this;
    }

    protected int getOrderableVariantType() {
        if (Modifier.isFinal(this.field.getModifiers())) {
            return 3;
        }
        return 0;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        methodBuilder.getStaticField(this.field.getDeclaringClass().getName(), this.fieldName, this.getJavaTypeName());
    }
}

