/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.SignedBinary;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetLogWriter;

public class Reply {
    protected Agent agent_;
    protected NetAgent netAgent_;
    protected static final int DEFAULT_BUFFER_SIZE = Short.MAX_VALUE;
    protected byte[] buffer_;
    protected int pos_;
    protected int count_;
    private int topDdmCollectionStack_;
    private static final int MAX_MARKS_NESTING = 10;
    private int[] ddmCollectionLenStack_;
    private int ddmScalarLen_;
    private static final int EMPTY_STACK = -1;
    protected boolean ensuredLengthForDecryption_ = false;
    protected byte[] longBufferForDecryption_ = null;
    protected int longPosForDecryption_ = 0;
    protected byte[] longValueForDecryption_ = null;
    protected int longCountForDecryption_ = 0;
    protected int dssLength_;
    protected boolean dssIsContinued_;
    private boolean dssIsChainedWithSameID_;
    private boolean dssIsChainedWithDiffID_;
    protected int dssCorrelationID_;
    protected int peekedLength_ = 0;
    protected int peekedCodePoint_ = -1;
    private int peekedNumOfExtendedLenBytes_ = 0;
    private int currentPos_ = 0;
    public static final int END_OF_COLLECTION = -1;
    public static final int END_OF_SAME_ID_CHAIN = -2;

    Reply(NetAgent netAgent, int n) {
        this.buffer_ = new byte[n];
        this.netAgent_ = netAgent;
        this.agent_ = this.netAgent_;
        this.ddmCollectionLenStack_ = new int[10];
        this.initialize();
    }

    final void initialize() {
        this.pos_ = 0;
        this.count_ = 0;
        this.topDdmCollectionStack_ = -1;
        Arrays.fill(this.ddmCollectionLenStack_, 0);
        this.ddmScalarLen_ = 0;
        this.dssLength_ = 0;
        this.dssIsContinued_ = false;
        this.dssIsChainedWithSameID_ = false;
        this.dssIsChainedWithDiffID_ = false;
        this.dssCorrelationID_ = 1;
    }

    final int getDdmLength() {
        return this.ddmScalarLen_;
    }

    private final void shiftBuffer(byte[] byArray) {
        int n = this.count_ - this.pos_;
        System.arraycopy(this.buffer_, this.pos_, byArray, 0, n);
        this.pos_ = 0;
        this.count_ = n;
        this.buffer_ = byArray;
    }

    protected final void ensureSpaceInBufferForFill(int n) {
        int n2 = this.buffer_.length - this.count_ + this.pos_;
        if (n2 < n) {
            int n3 = n - n2 + this.buffer_.length;
            int n4 = 2 * this.buffer_.length;
            int n5 = n3 <= n4 ? n4 : n3;
            byte[] byArray = new byte[n5];
            this.shiftBuffer(byArray);
        } else if (this.pos_ != 0) {
            this.shiftBuffer(this.buffer_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int fill(int n) throws DisconnectException {
        this.ensureSpaceInBufferForFill(n);
        int n2 = 0;
        int n3 = 0;
        do {
            try {
                n3 = this.netAgent_.getInputStream().read(this.buffer_, this.count_, this.buffer_.length - this.count_);
            }
            catch (IOException iOException) {
                this.netAgent_.throwCommunicationsFailure(iOException);
            }
            finally {
                if (this.agent_.loggingEnabled()) {
                    ((NetLogWriter)this.netAgent_.logWriter_).traceProtocolFlow(this.buffer_, this.count_, n3, 2, "Reply", "fill", 2);
                }
            }
            if (n3 <= 0) continue;
            this.count_ += n3;
            n2 += n3;
        } while (n2 < n && n3 != -1);
        if (n3 == -1 && n2 < n) {
            this.netAgent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this.netAgent_, new ClientMessageId("08006.C.5"), (Object)n, (Object)n2));
        }
        return n2;
    }

    protected final int ensureALayerDataInBuffer(int n) throws DisconnectException {
        int n2 = 0;
        int n3 = this.count_ - this.pos_;
        if (n3 < n) {
            n2 = this.fill(n - n3);
        }
        return n2;
    }

    protected final void ensureBLayerDataInBuffer(int n) throws DisconnectException {
        if (this.dssIsContinued_ && n > this.dssLength_) {
            int n2 = (n - this.dssLength_) / Short.MAX_VALUE + 1;
            this.ensureALayerDataInBuffer(n + n2 * 2);
            this.compressBLayerData(n2);
            return;
        }
        this.ensureALayerDataInBuffer(n);
    }

    private final void compressBLayerData(int n) throws DisconnectException {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (n2 == 0) {
                n3 = this.pos_ + this.dssLength_;
                continue;
            }
            n3 += Short.MAX_VALUE;
        }
        n2 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            n5 = ((this.buffer_[n3] & 0xFF) << 8) + ((this.buffer_[n3 + 1] & 0xFF) << 0);
            if (i == 0) {
                if ((n5 & 0x8000) == 32768) {
                    n5 = Short.MAX_VALUE;
                    this.dssIsContinued_ = true;
                } else {
                    this.dssIsContinued_ = false;
                }
                n2 = 2;
            } else {
                if ((n5 & 0x8000) == 32768) {
                    n5 = Short.MAX_VALUE;
                } else {
                    this.doSyntaxrmSemantics(CodePoint.SYNERRCD_DSS_LENGTH_BYTE_NUMBER_MISMATCH);
                }
                n2 += 2;
            }
            if (n5 <= 2) {
                this.doSyntaxrmSemantics(CodePoint.SYNERRCD_DSS_CONT_LESS_OR_EQUAL_2);
            }
            n6 += n5 - 2;
            n4 = i != n - 1 ? Short.MAX_VALUE : this.dssLength_;
            System.arraycopy(this.buffer_, (n3 -= n4 - 2) - n2, this.buffer_, n3, n4);
        }
        this.pos_ = n3;
        this.dssLength_ += n6;
    }

    protected final void readDssHeader() throws DisconnectException {
        int n;
        int n2 = 0;
        int n3 = 0;
        this.ensureALayerDataInBuffer(6);
        int n4 = this.dssLength_ = ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
        if ((this.dssLength_ & 0x8000) == 32768) {
            this.dssLength_ = Short.MAX_VALUE;
            this.dssIsContinued_ = true;
        } else {
            this.dssIsContinued_ = false;
        }
        if (this.dssLength_ < 6) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_DSS_LESS_THAN_6);
        }
        if ((this.buffer_[this.pos_++] & 0xFF) != 208) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_CBYTE_NOT_D0);
        }
        if (((n = this.buffer_[this.pos_++] & 0xFF) & 2) != 2 && (n & 3) != 3 && (n & 4) != 4) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_FBYTE_NOT_SUPPORTED);
        }
        if ((n & 0x40) == 64) {
            if ((n & 0x10) == 16) {
                this.dssIsChainedWithSameID_ = true;
                this.dssIsChainedWithDiffID_ = false;
                n3 = this.dssCorrelationID_;
            } else {
                this.dssIsChainedWithSameID_ = false;
                this.dssIsChainedWithDiffID_ = true;
                n3 = this.dssCorrelationID_ + 1;
            }
        } else {
            if ((n & 0x10) == 16) {
                this.doSyntaxrmSemantics(CodePoint.SYNERRCD_CHAIN_OFF_SAME_NEXT_CORRELATOR);
            }
            if ((n & 0x20) == 32) {
                this.doSyntaxrmSemantics(CodePoint.SYNERRCD_CHAIN_OFF_ERROR_CONTINUE);
            }
            this.dssIsChainedWithSameID_ = false;
            this.dssIsChainedWithDiffID_ = false;
            n3 = 1;
        }
        n2 = ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
        if (n2 != this.dssCorrelationID_ && n2 != 65535) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_INVALID_CORRELATOR);
        } else {
            this.dssCorrelationID_ = n3;
        }
        this.dssLength_ -= 6;
        if ((n & 4) == 4) {
            this.decryptData(n, n4);
        }
    }

    private final void decryptData(int n, int n2) throws DisconnectException {
        if (this.dssLength_ == 32761) {
            boolean bl;
            int n3 = 0;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            n3 = this.dssLength_;
            do {
                bl = this.dssIsContinued_;
                this.ensureALayerDataInBuffer(n3);
                this.adjustLengths(n3);
                byteArrayOutputStream.write(this.buffer_, this.pos_, n3);
                this.pos_ += n3;
                if (bl) {
                    this.readDSSContinuationHeader();
                }
                n3 = this.dssLength_;
            } while (bl);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byte[] byArray2 = null;
            try {
                byArray2 = this.netAgent_.netConnection_.getEncryptionManager().decryptData(byArray, 9, this.netAgent_.netConnection_.getTargetPublicKey(), this.netAgent_.netConnection_.getTargetPublicKey());
            }
            catch (SqlException sqlException) {
                // empty catch block
            }
            this.longBufferForDecryption_ = new byte[this.buffer_.length - this.pos_];
            this.longPosForDecryption_ = 0;
            this.count_ -= this.pos_;
            this.longCountForDecryption_ = this.count_;
            System.arraycopy(this.buffer_, this.pos_, this.longBufferForDecryption_, 0, this.buffer_.length - this.pos_);
            if (byArray2.length >= Short.MAX_VALUE) {
                System.arraycopy(byArray2, 0, this.buffer_, 0, Short.MAX_VALUE);
            } else {
                System.arraycopy(byArray2, 0, this.buffer_, 0, byArray2.length);
            }
            this.pos_ = 0;
            this.dssLength_ = this.buffer_.length;
            int n4 = 0;
            if (byArray2.length > Short.MAX_VALUE) {
                n4 = ((byArray2[4] & 0xFF) << 24) + ((byArray2[5] & 0xFF) << 16) + ((byArray2[6] & 0xFF) << 8) + ((byArray2[7] & 0xFF) << 0);
                this.longValueForDecryption_ = new byte[n4];
                System.arraycopy(byArray2, 8, this.longValueForDecryption_, 0, byArray2.length - 8);
            } else {
                n4 = ((byArray2[0] & 0xFF) << 8) + ((byArray2[1] & 0xFF) << 0);
                this.longValueForDecryption_ = new byte[n4 - 4];
                System.arraycopy(byArray2, 4, this.longValueForDecryption_, 0, byArray2.length - 4);
            }
        } else {
            int n5 = this.ensureALayerDataInBuffer(this.dssLength_);
            if (n5 > 0) {
                this.ensuredLengthForDecryption_ = true;
            }
            byte[] byArray = new byte[this.dssLength_];
            System.arraycopy(this.buffer_, this.pos_, byArray, 0, this.dssLength_);
            byte[] byArray3 = new byte[this.pos_];
            System.arraycopy(this.buffer_, 0, byArray3, 0, this.pos_);
            byte[] byArray4 = new byte[this.buffer_.length - this.dssLength_ - this.pos_];
            System.arraycopy(this.buffer_, this.pos_ + this.dssLength_, byArray4, 0, this.buffer_.length - this.dssLength_ - this.pos_);
            byte[] byArray5 = null;
            try {
                byArray5 = this.netAgent_.netConnection_.getEncryptionManager().decryptData(byArray, 9, this.netAgent_.netConnection_.getTargetPublicKey(), this.netAgent_.netConnection_.getTargetPublicKey());
            }
            catch (SqlException sqlException) {
                // empty catch block
            }
            this.dssLength_ -= byArray.length - byArray5.length;
            byte[] byArray6 = new byte[byArray3.length + byArray5.length + byArray4.length];
            System.arraycopy(byArray3, 0, byArray6, 0, byArray3.length);
            System.arraycopy(byArray5, 0, byArray6, byArray3.length, byArray5.length);
            System.arraycopy(byArray4, 0, byArray6, byArray3.length + byArray5.length, byArray4.length);
            this.buffer_ = byArray6;
            int n6 = this.count_;
            this.count_ -= byArray.length - byArray5.length;
            if (((byArray5[2] & 0xFF) << 8) + ((byArray5[3] & 0xFF) << 0) == 5228) {
                int n7;
                boolean bl = false;
                if (n == 84) {
                    bl = true;
                }
                if (bl) {
                    n7 = ((byArray5[0] & 0xFF) << 8) + ((byArray5[1] & 0xFF) << 0);
                    if (n6 - n2 < 6) {
                        int n8 = this.fill(6);
                        if (n8 > 0) {
                            this.longBufferForDecryption_ = new byte[n8];
                            this.longPosForDecryption_ = 0;
                            System.arraycopy(this.buffer_, this.pos_ + n7, this.longBufferForDecryption_, 0, n8);
                        }
                    } else {
                        this.longBufferForDecryption_ = new byte[this.count_ - this.pos_ - n7];
                        this.longPosForDecryption_ = 0;
                        System.arraycopy(this.buffer_, this.pos_ + n7, this.longBufferForDecryption_, 0, this.longBufferForDecryption_.length);
                    }
                }
                n7 = ((byArray5[0] & 0xFF) << 8) + ((byArray5[1] & 0xFF) << 0) - 4;
                this.longValueForDecryption_ = new byte[n7];
                System.arraycopy(byArray5, 4, this.longValueForDecryption_, 0, byArray5.length - 4);
            } else if (((byArray5[2] & 0xFF) << 8) + ((byArray5[3] & 0xFF) << 0) == 9243) {
                int n9 = ((byArray5[0] & 0xFF) << 8) + ((byArray5[1] & 0xFF) << 0);
                boolean bl = false;
                if (byArray5[4] == -1 && byArray5[5] == -1) {
                    bl = true;
                }
                if (!bl) {
                    if (n9 == 32776) {
                        n9 = ((byArray5[4] & 0xFF) << 24) + ((byArray5[5] & 0xFF) << 16) + ((byArray5[6] & 0xFF) << 8) + ((byArray5[7] & 0xFF) << 0);
                        this.longValueForDecryption_ = new byte[n9];
                        System.arraycopy(byArray5, 8, this.longValueForDecryption_, 0, byArray5.length - 8);
                        this.longCountForDecryption_ = this.count_ - (this.pos_ + n9 + 8);
                        this.longBufferForDecryption_ = new byte[this.buffer_.length - this.pos_ - n9 - 8];
                        System.arraycopy(this.buffer_, this.pos_ + n9 + 8, this.longBufferForDecryption_, 0, this.longBufferForDecryption_.length);
                    } else {
                        this.longPosForDecryption_ = 0;
                        this.longCountForDecryption_ = this.count_ - (this.pos_ + n9);
                        this.longBufferForDecryption_ = new byte[this.buffer_.length - this.pos_ - n9];
                        System.arraycopy(this.buffer_, this.pos_ + n9, this.longBufferForDecryption_, 0, this.longBufferForDecryption_.length);
                        this.longValueForDecryption_ = new byte[n9 - 4];
                        System.arraycopy(byArray5, 4, this.longValueForDecryption_, 0, byArray5.length - 4);
                    }
                }
            }
        }
    }

    final int readUnsignedShort() throws DisconnectException {
        this.ensureBLayerDataInBuffer(2);
        this.adjustLengths(2);
        return ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
    }

    final short readShort() throws DisconnectException {
        this.ensureBLayerDataInBuffer(2);
        this.adjustLengths(2);
        short s = SignedBinary.getShort(this.buffer_, this.pos_);
        this.pos_ += 2;
        return s;
    }

    final int readInt() throws DisconnectException {
        this.ensureBLayerDataInBuffer(4);
        this.adjustLengths(4);
        int n = SignedBinary.getInt(this.buffer_, this.pos_);
        this.pos_ += 4;
        return n;
    }

    final void readIntArray(int[] nArray) throws DisconnectException {
        this.ensureBLayerDataInBuffer(nArray.length * 4);
        this.adjustLengths(nArray.length * 4);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = SignedBinary.getInt(this.buffer_, this.pos_);
            this.pos_ += 4;
        }
    }

    final long readLong() throws DisconnectException {
        this.ensureBLayerDataInBuffer(8);
        this.adjustLengths(8);
        long l = SignedBinary.getLong(this.buffer_, this.pos_);
        this.pos_ += 8;
        return l;
    }

    final int[] readUnsignedShortList() throws DisconnectException {
        int n = this.ddmScalarLen_;
        this.ensureBLayerDataInBuffer(n);
        this.adjustLengths(n);
        int n2 = n / 2;
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
        }
        return nArray;
    }

    final int readUnsignedByte() throws DisconnectException {
        this.ensureBLayerDataInBuffer(1);
        this.adjustLengths(1);
        return this.buffer_[this.pos_++] & 0xFF;
    }

    final byte readByte() throws DisconnectException {
        this.ensureBLayerDataInBuffer(1);
        this.adjustLengths(1);
        return (byte)(this.buffer_[this.pos_++] & 0xFF);
    }

    final boolean readBoolean() throws DisconnectException {
        this.ensureBLayerDataInBuffer(1);
        this.adjustLengths(1);
        return this.buffer_[this.pos_++] != 0;
    }

    final String readString(int n) throws DisconnectException {
        this.ensureBLayerDataInBuffer(n);
        this.adjustLengths(n);
        String string = this.netAgent_.getCurrentCcsidManager().convertToJavaString(this.buffer_, this.pos_, n);
        this.pos_ += n;
        return string;
    }

    final String readString(int n, String string) throws DisconnectException {
        this.ensureBLayerDataInBuffer(n);
        this.adjustLengths(n);
        String string2 = null;
        try {
            string2 = new String(this.buffer_, this.pos_, n, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.11"), (Object)unsupportedEncodingException));
        }
        this.pos_ += n;
        return string2;
    }

    final String readString() throws DisconnectException {
        int n = this.ddmScalarLen_;
        this.ensureBLayerDataInBuffer(n);
        this.adjustLengths(n);
        String string = this.netAgent_.getCurrentCcsidManager().convertToJavaString(this.buffer_, this.pos_, n);
        this.pos_ += n;
        return string;
    }

    final byte[] readBytes(int n) throws DisconnectException {
        this.ensureBLayerDataInBuffer(n);
        this.adjustLengths(n);
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer_, this.pos_, byArray, 0, n);
        this.pos_ += n;
        return byArray;
    }

    final byte[] readBytes() throws DisconnectException {
        int n = this.ddmScalarLen_;
        this.ensureBLayerDataInBuffer(n);
        this.adjustLengths(n);
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer_, this.pos_, byArray, 0, n);
        this.pos_ += n;
        return byArray;
    }

    final byte[] readLDBytes() throws DisconnectException {
        this.ensureBLayerDataInBuffer(2);
        int n = ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
        if (n == 0) {
            this.adjustLengths(2);
            return null;
        }
        this.ensureBLayerDataInBuffer(n);
        this.adjustLengths(n + 2);
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer_, this.pos_, byArray, 0, n);
        this.pos_ += n;
        return byArray;
    }

    final void skipBytes(int n) throws DisconnectException {
        this.ensureBLayerDataInBuffer(n);
        this.adjustLengths(n);
        this.pos_ += n;
    }

    final void skipBytes() throws DisconnectException {
        int n = this.ddmScalarLen_;
        this.ensureBLayerDataInBuffer(n);
        this.adjustLengths(n);
        this.pos_ += n;
    }

    final ByteArrayOutputStream getData(ByteArrayOutputStream byteArrayOutputStream) throws DisconnectException {
        boolean bl;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream != null ? byteArrayOutputStream : (this.ddmScalarLen_ != -1 ? new ByteArrayOutputStream(this.ddmScalarLen_) : new ByteArrayOutputStream());
        int n = this.dssLength_;
        do {
            bl = this.dssIsContinued_;
            this.ensureALayerDataInBuffer(n);
            this.adjustLengths(n);
            byteArrayOutputStream2.write(this.buffer_, this.pos_, n);
            this.pos_ += n;
            if (bl) {
                this.readDSSContinuationHeader();
            }
            n = this.dssLength_;
        } while (bl);
        return byteArrayOutputStream2;
    }

    protected final void readDSSContinuationHeader() throws DisconnectException {
        this.ensureALayerDataInBuffer(2);
        this.dssLength_ = ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
        if ((this.dssLength_ & 0x8000) == 32768) {
            this.dssLength_ = Short.MAX_VALUE;
            this.dssIsContinued_ = true;
        } else {
            this.dssIsContinued_ = false;
        }
        if (this.dssLength_ <= 2) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_DSS_CONT_LESS_OR_EQUAL_2);
        }
        this.dssLength_ -= 2;
    }

    final void doSyntaxrmSemantics(int n) throws DisconnectException {
        DisconnectException disconnectException = new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)SqlException.getMessageUtil().getTextMessage("J131", n));
        if (this.netAgent_.exceptionConvertingRdbnam != null) {
            disconnectException.setNextException(this.netAgent_.exceptionConvertingRdbnam);
            this.netAgent_.exceptionConvertingRdbnam = null;
        }
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(disconnectException);
    }

    protected final void pushLengthOnCollectionStack() {
        this.ddmCollectionLenStack_[++this.topDdmCollectionStack_] = this.ddmScalarLen_;
        this.ddmScalarLen_ = 0;
    }

    protected final void adjustLengths(int n) {
        this.ddmScalarLen_ -= n;
        this.adjustCollectionAndDssLengths(n);
    }

    protected int adjustDdmLength(int n, int n2) {
        if ((n -= n2) == 0) {
            this.adjustLengths(this.getDdmLength());
        }
        return n;
    }

    protected final void popCollectionStack() {
        --this.topDdmCollectionStack_;
    }

    protected final int peekCodePoint() throws DisconnectException {
        if (this.topDdmCollectionStack_ != -1) {
            if (this.ddmCollectionLenStack_[this.topDdmCollectionStack_] == 0) {
                return -1;
            }
            if (this.ddmCollectionLenStack_[this.topDdmCollectionStack_] < 4) {
                // empty if block
            }
        }
        if (this.dssLength_ == 0 && !this.dssIsContinued_) {
            if (!this.dssIsChainedWithSameID_) {
                return -2;
            }
            this.readDssHeader();
        }
        if (this.longBufferForDecryption_ == null) {
            this.ensureBLayerDataInBuffer(4);
        }
        this.peekedLength_ = ((this.buffer_[this.pos_] & 0xFF) << 8) + ((this.buffer_[this.pos_ + 1] & 0xFF) << 0);
        this.peekedCodePoint_ = ((this.buffer_[this.pos_ + 2] & 0xFF) << 8) + ((this.buffer_[this.pos_ + 3] & 0xFF) << 0);
        if ((this.peekedLength_ & 0x8000) == 32768) {
            this.peekExtendedLength();
        } else {
            this.peekedNumOfExtendedLenBytes_ = 0;
        }
        return this.peekedCodePoint_;
    }

    protected final int peekLength() throws DisconnectException {
        this.ensureBLayerDataInBuffer(2);
        return ((this.buffer_[this.pos_] & 0xFF) << 8) + ((this.buffer_[this.pos_ + 1] & 0xFF) << 0);
    }

    protected final int peekFastBytes(byte[] byArray, int n, int n2) throws DisconnectException {
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = this.buffer_[this.pos_ + i];
        }
        return n + n2;
    }

    protected final void parseLengthAndMatchCodePoint(int n) throws DisconnectException {
        int n2 = 0;
        if (this.peekedCodePoint_ == -1) {
            n2 = this.readLengthAndCodePoint();
        } else {
            n2 = this.peekedCodePoint_;
            this.pos_ += 4 + this.peekedNumOfExtendedLenBytes_;
            this.ddmScalarLen_ = this.peekedLength_;
            if (this.peekedNumOfExtendedLenBytes_ == 0 && this.ddmScalarLen_ != -1) {
                this.adjustLengths(4);
            } else {
                this.adjustCollectionAndDssLengths(4 + this.peekedNumOfExtendedLenBytes_);
            }
            this.peekedLength_ = 0;
            this.peekedCodePoint_ = -1;
            this.peekedNumOfExtendedLenBytes_ = 0;
        }
        if (n2 != n) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.12"), (Object)n2, (Object)n));
        }
    }

    protected final int readLengthAndCodePoint() throws DisconnectException {
        if (this.topDdmCollectionStack_ != -1) {
            if (this.ddmCollectionLenStack_[this.topDdmCollectionStack_] == 0) {
                return -1;
            }
            if (this.ddmCollectionLenStack_[this.topDdmCollectionStack_] < 4) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.13")));
            }
        }
        if (this.dssLength_ == 0 && !this.dssIsContinued_) {
            if (!this.dssIsChainedWithSameID_) {
                return -2;
            }
            this.readDssHeader();
        }
        this.ensureBLayerDataInBuffer(4);
        this.ddmScalarLen_ = ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
        int n = ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
        this.adjustLengths(4);
        if ((this.ddmScalarLen_ & 0x8000) == 32768) {
            this.readExtendedLength();
        }
        return n;
    }

    private final void readExtendedLength() throws DisconnectException {
        int n = this.ddmScalarLen_ - 32768;
        int n2 = 0;
        switch (n) {
            case 4: {
                this.ensureBLayerDataInBuffer(4);
                this.ddmScalarLen_ = ((this.buffer_[this.pos_++] & 0xFF) << 24) + ((this.buffer_[this.pos_++] & 0xFF) << 16) + ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
                n2 = 4;
                break;
            }
            case 0: {
                this.ddmScalarLen_ = -1;
                n2 = 0;
                break;
            }
            default: {
                this.doSyntaxrmSemantics(CodePoint.SYNERRCD_INCORRECT_EXTENDED_LEN);
            }
        }
        this.adjustCollectionAndDssLengths(n2);
    }

    private final void adjustCollectionAndDssLengths(int n) {
        int n2 = 0;
        while (n2 <= this.topDdmCollectionStack_) {
            int n3 = n2++;
            this.ddmCollectionLenStack_[n3] = this.ddmCollectionLenStack_[n3] - n;
        }
        this.dssLength_ -= n;
    }

    protected final void startSameIdChainParse() throws DisconnectException {
        this.readDssHeader();
        this.netAgent_.clearSvrcod();
    }

    protected final void endOfSameIdChainData() throws DisconnectException {
        this.netAgent_.targetTypdef_ = this.netAgent_.originalTargetTypdef_;
        this.netAgent_.targetSqlam_ = this.netAgent_.orignalTargetSqlam_;
        if (this.topDdmCollectionStack_ != -1) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.14")));
        }
        if (this.dssLength_ != 0) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.15")));
        }
        if (this.dssIsChainedWithSameID_) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.16")));
        }
    }

    protected final int peekTotalColumnCount(int n) throws DisconnectException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 127;
        while (n4 == 127) {
            n2 += (n - 3) / 3;
            this.ensureBLayerDataInBuffer(n - 3);
            n3 += n - 3;
            n = this.buffer_[this.pos_ + n3++] & 0xFF;
            n4 = this.buffer_[this.pos_ + n3++] & 0xFF;
            ++n3;
        }
        return n2;
    }

    private final void peekExtendedLength() throws DisconnectException {
        this.peekedNumOfExtendedLenBytes_ = this.peekedLength_ - 32772;
        switch (this.peekedNumOfExtendedLenBytes_) {
            case 4: {
                if (this.longBufferForDecryption_ == null) {
                    this.ensureBLayerDataInBuffer(8);
                }
                this.peekedLength_ = ((this.buffer_[this.pos_ + 4] & 0xFF) << 24) + ((this.buffer_[this.pos_ + 5] & 0xFF) << 16) + ((this.buffer_[this.pos_ + 6] & 0xFF) << 8) + ((this.buffer_[this.pos_ + 7] & 0xFF) << 0);
                break;
            }
            case 0: {
                this.peekedLength_ = -1;
                break;
            }
            default: {
                this.doSyntaxrmSemantics(CodePoint.SYNERRCD_INCORRECT_EXTENDED_LEN);
            }
        }
    }

    final int readFastUnsignedByte() throws DisconnectException {
        return this.buffer_[this.pos_++] & 0xFF;
    }

    final short readFastShort() throws DisconnectException {
        short s = SignedBinary.getShort(this.buffer_, this.pos_);
        this.pos_ += 2;
        return s;
    }

    final int readFastUnsignedShort() throws DisconnectException {
        return ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0);
    }

    final int readFastInt() throws DisconnectException {
        int n = SignedBinary.getInt(this.buffer_, this.pos_);
        this.pos_ += 4;
        return n;
    }

    final String readFastString(int n) throws DisconnectException {
        String string = this.netAgent_.getCurrentCcsidManager().convertToJavaString(this.buffer_, this.pos_, n);
        this.pos_ += n;
        return string;
    }

    final byte[] readFastBytes(int n) throws DisconnectException {
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer_, this.pos_, byArray, 0, n);
        this.pos_ += n;
        return byArray;
    }

    protected final int peekFastLength() throws DisconnectException {
        return ((this.buffer_[this.pos_] & 0xFF) << 8) + ((this.buffer_[this.pos_ + 1] & 0xFF) << 0);
    }

    final void skipFastBytes(int n) throws DisconnectException {
        this.pos_ += n;
    }

    final void readFastIntArray(int[] nArray) throws DisconnectException {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = SignedBinary.getInt(this.buffer_, this.pos_);
            this.pos_ += 4;
        }
    }

    final String readFastString(int n, String string) throws DisconnectException {
        String string2 = null;
        try {
            string2 = new String(this.buffer_, this.pos_, n, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.11"), (Object)unsupportedEncodingException));
        }
        this.pos_ += n;
        return string2;
    }

    final byte[] readFastLDBytes() throws DisconnectException {
        int n;
        if ((n = ((this.buffer_[this.pos_++] & 0xFF) << 8) + ((this.buffer_[this.pos_++] & 0xFF) << 0)) == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer_, this.pos_, byArray, 0, n);
        this.pos_ += n;
        return byArray;
    }

    final long readFastLong() throws DisconnectException {
        long l = SignedBinary.getLong(this.buffer_, this.pos_);
        this.pos_ += 8;
        return l;
    }

    final byte readFastByte() throws DisconnectException {
        return (byte)(this.buffer_[this.pos_++] & 0xFF);
    }

    final void mark() {
        this.currentPos_ = this.pos_;
    }

    final int popMark() {
        return this.currentPos_;
    }

    final int getFastSkipSQLCARDrowLength() {
        return this.pos_ - this.popMark();
    }

    final ByteArrayOutputStream getFastData(ByteArrayOutputStream byteArrayOutputStream) throws DisconnectException {
        boolean bl;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream != null ? byteArrayOutputStream : (this.ddmScalarLen_ != -1 ? new ByteArrayOutputStream(this.ddmScalarLen_) : new ByteArrayOutputStream());
        int n = this.dssLength_;
        do {
            bl = this.dssIsContinued_;
            this.adjustLengths(n);
            byteArrayOutputStream2.write(this.buffer_, this.pos_, n);
            this.pos_ += n;
            if (bl) {
                this.readDSSContinuationHeader();
            }
            n = this.dssLength_;
        } while (bl);
        return byteArrayOutputStream2;
    }

    protected final void matchCodePoint(int n) throws DisconnectException {
        int n2 = 0;
        n2 = this.peekedCodePoint_;
        this.pos_ += 4;
        if (n2 != n) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.12"), (Object)n2, (Object)n));
        }
    }

    protected final int peekNumOfColumns() throws DisconnectException {
        int n = 4 + this.peekedNumOfExtendedLenBytes_ + 1;
        n = this.skipSQLDHROW(n);
        return SignedBinary.getShort(this.buffer_, this.pos_ + n);
    }

    protected final boolean peekForNullSqlcagrp() {
        int n = 4 + this.peekedNumOfExtendedLenBytes_;
        int n2 = this.buffer_[this.pos_ + n] & 0xFF;
        return n2 == 255;
    }

    private final int skipSQLDHROW(int n) {
        int n2;
        if ((n2 = this.buffer_[this.pos_ + n++] & 0xFF) == 255) {
            return n;
        }
        n += 12;
        int n3 = ((this.buffer_[this.pos_ + n++] & 0xFF) << 8) + ((this.buffer_[this.pos_ + n++] & 0xFF) << 0);
        n += n3;
        n3 = ((this.buffer_[this.pos_ + n++] & 0xFF) << 8) + ((this.buffer_[this.pos_ + n++] & 0xFF) << 0);
        n += n3;
        n3 = ((this.buffer_[this.pos_ + n++] & 0xFF) << 8) + ((this.buffer_[this.pos_ + n++] & 0xFF) << 0);
        return n += n3;
    }
}

