/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jboss.logging.Logger;

public class BeanManagerResourceBindingListener
implements ServletContextListener {
    private static final Logger log = Logger.getLogger(BeanManagerResourceBindingListener.class);
    private static final String RESOURCES_CONTEXT = "java:comp/env";
    private static final String BEAN_MANAGER_JNDI_NAME = "BeanManager";
    private static final String QUALIFIED_BEAN_MANAGER_JNDI_NAME = "java:comp/env/BeanManager";
    private static final String BEAN_MANAGER_OBJECT_FACTORY = "org.jboss.weld.resources.ManagerObjectFactory";
    private boolean bound = false;

    public void contextInitialized(ServletContextEvent sce) {
        block12: {
            try {
                InitialContext ctx = new InitialContext();
                boolean present = false;
                try {
                    NamingEnumeration<NameClassPair> entries = ctx.list(RESOURCES_CONTEXT);
                    while (entries.hasMoreElements()) {
                        try {
                            NameClassPair e = entries.next();
                            if (!e.getName().equals(BEAN_MANAGER_JNDI_NAME) || !e.getClassName().equals(BeanManager.class)) continue;
                            present = true;
                            break;
                        }
                        catch (Exception e) {
                            log.info((Object)"Problem when iterating through java:comp/env", e);
                        }
                    }
                }
                catch (NamingException e) {
                    log.infov("Could not read context {0}: Trying to create it!", (Object)RESOURCES_CONTEXT);
                    try {
                        Context compCtx = (Context)ctx.lookup("java:comp");
                        compCtx.createSubcontext("env");
                    }
                    catch (Exception ex) {
                        log.errorv("Could not create context: {0}", (Object)RESOURCES_CONTEXT);
                    }
                }
                if (present) break block12;
                try {
                    ctx.rebind(QUALIFIED_BEAN_MANAGER_JNDI_NAME, (Object)new Reference(BeanManager.class.getName(), BEAN_MANAGER_OBJECT_FACTORY, null));
                    this.bound = true;
                    log.infov("BeanManager reference bound to {0}", (Object)QUALIFIED_BEAN_MANAGER_JNDI_NAME);
                }
                catch (NamingException e) {
                    throw new RuntimeException("Could not bind BeanManager reference to JNDI: " + e.getExplanation() + " \n" + "If the naming context is read-only, you may need to use a configuration to" + "bind the BeanManager instead, such as Tomcat's context.xml or Jetty's jetty-web.xml.");
                }
            }
            catch (NamingException e) {
                throw new RuntimeException("Could not create InitialContext to bind BeanManager reference in JNDI: " + e.getExplanation());
            }
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.bound) {
            try {
                InitialContext ctx = new InitialContext();
                ctx.unbind(QUALIFIED_BEAN_MANAGER_JNDI_NAME);
                log.info("Successfully unbound BeanManager reference.");
            }
            catch (NamingException e) {
                log.warn("Failed to unbind BeanManager reference!");
            }
        }
    }
}

