/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.compound.factories;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.FifoPolicy;
import net.sf.ehcache.store.LfuPolicy;
import net.sf.ehcache.store.LruPolicy;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.compound.CompoundStore;
import net.sf.ehcache.store.compound.ElementSubstitute;
import net.sf.ehcache.store.compound.ElementSubstituteFilter;
import net.sf.ehcache.store.compound.factories.DiskStorageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskPersistentStorageFactory
extends DiskStorageFactory<ElementSubstitute> {
    private static final Logger LOG = LoggerFactory.getLogger(DiskPersistentStorageFactory.class);
    private static final int MAX_EVICT = 5;
    private static final int SAMPLE_SIZE = 30;
    private final ElementSubstituteFilter<DiskStorageFactory.DiskSubstitute> inMemoryFilter = new InMemoryFilter();
    private final ElementSubstituteFilter<CachingDiskMarker> flushableFilter = new FlushableFilter();
    private final ElementSubstituteFilter<CachingDiskMarker> onDiskFilter = new OnDiskFilter();
    private final AtomicInteger inMemory = new AtomicInteger();
    private final AtomicInteger onDisk = new AtomicInteger();
    private final File indexFile;
    private final IndexWriteTask flushTask;
    private volatile int diskCapacity;
    private volatile int memoryCapacity;
    private volatile Policy memoryPolicy;

    public DiskPersistentStorageFactory(Ehcache cache, String diskPath) {
        super(DiskPersistentStorageFactory.getDataFile(diskPath, cache), cache.getCacheConfiguration().getDiskExpiryThreadIntervalSeconds(), cache.getCacheConfiguration().getDiskSpoolBufferSizeMB(), cache.getCacheEventNotificationService(), false, cache.getCacheConfiguration().getDiskAccessStripes());
        this.indexFile = new File(this.getDataFile().getParentFile(), DiskPersistentStorageFactory.getIndexFileName(cache));
        this.flushTask = new IndexWriteTask(this.indexFile, cache.getCacheConfiguration().isClearOnFlush());
        if (!this.getDataFile().exists() || this.getDataFile().length() == 0L) {
            LOG.debug("Matching data file missing (or empty) for index file. Deleting index file " + this.indexFile);
            this.indexFile.delete();
        } else if (this.getDataFile().exists() && this.indexFile.exists() && this.getDataFile().lastModified() > this.indexFile.lastModified() + TimeUnit.SECONDS.toMillis(1L)) {
            LOG.warn("The index for data file {} is out of date, probably due to an unclean shutdown. Deleting index file {}", (Object)this.getDataFile(), (Object)this.indexFile);
            this.indexFile.delete();
        }
        this.diskCapacity = cache.getCacheConfiguration().getMaxElementsOnDisk();
        this.memoryCapacity = cache.getCacheConfiguration().getMaxElementsInMemory();
        this.memoryPolicy = DiskPersistentStorageFactory.determineEvictionPolicy(cache.getCacheConfiguration());
    }

    private static final Policy determineEvictionPolicy(CacheConfiguration config) {
        MemoryStoreEvictionPolicy policySelection = config.getMemoryStoreEvictionPolicy();
        if (policySelection.equals(MemoryStoreEvictionPolicy.LRU)) {
            return new LruPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.FIFO)) {
            return new FifoPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.LFU)) {
            return new LfuPolicy();
        }
        throw new IllegalArgumentException(policySelection + " isn't a valid eviction policy");
    }

    private static File getDataFile(String diskPath, Ehcache cache) {
        if (diskPath == null) {
            throw new CacheException(cache.getName() + " Cache: Could not create disk store. " + "This CacheManager configuration does not allow creation of DiskStores. " + "If you wish to create DiskStores, please configure a diskStore path.");
        }
        File diskDir = new File(diskPath);
        if (diskDir.exists() && !diskDir.isDirectory()) {
            throw new CacheException("Store directory \"" + diskDir.getAbsolutePath() + "\" exists and is not a directory.");
        }
        if (!diskDir.exists() && !diskDir.mkdirs()) {
            throw new CacheException("Could not create cache directory \"" + diskDir.getAbsolutePath() + "\".");
        }
        File data = new File(diskDir, DiskPersistentStorageFactory.getDataFileName(cache));
        if (diskPath.indexOf("ehcache_auto_created") != -1) {
            LOG.warn("Data in persistent disk stores is ignored for stores from automatically created directories (they start with ehcache_auto_created).\nRemove diskPersistent or resolve the conflicting disk paths in cache configuration.\nDeleting data file " + data.getAbsolutePath());
            data.delete();
        }
        return data;
    }

    private static final String getDataFileName(Ehcache cache) {
        String safeName = cache.getName().replace('/', '_');
        return safeName + ".data";
    }

    private static final String getIndexFileName(Ehcache cache) {
        String safeName = cache.getName().replace('/', '_');
        return safeName + ".index";
    }

    @Override
    public ElementSubstitute create(Object key, Element element) throws IllegalArgumentException {
        int size = this.inMemory.incrementAndGet();
        this.inMemoryEvict(size, key);
        return new PersistentPlaceholder(element);
    }

    @Override
    public void free(Lock exclusion, ElementSubstitute object) {
        if (object instanceof PersistentPlaceholder) {
            this.inMemory.decrementAndGet();
        } else if (object instanceof CachingDiskMarker) {
            CachingDiskMarker marker = (CachingDiskMarker)object;
            this.onDisk.decrementAndGet();
            if (marker.flush()) {
                this.inMemory.decrementAndGet();
            }
        }
        super.free(exclusion, object);
    }

    @Override
    public Element retrieve(Object key, ElementSubstitute object) {
        if (object instanceof CachingDiskMarker) {
            try {
                CachingDiskMarker marker = (CachingDiskMarker)object;
                Element element = marker.getCached();
                if (element == null && marker.cache(element = this.read(marker))) {
                    int size = this.inMemory.incrementAndGet();
                    this.inMemoryEvict(size, key);
                }
                return element;
            }
            catch (IOException e) {
                throw new CacheException(e);
            }
            catch (ClassNotFoundException e) {
                throw new CacheException(e);
            }
        }
        if (object instanceof DiskStorageFactory.Placeholder) {
            return ((DiskStorageFactory.Placeholder)object).getElement();
        }
        return null;
    }

    @Override
    public boolean created(Object object) {
        if (object instanceof ElementSubstitute) {
            return ((ElementSubstitute)object).getFactory() == this;
        }
        return false;
    }

    @Override
    public void bind(CompoundStore store) {
        super.bind(store);
        this.loadIndex();
    }

    @Override
    public void unbind(CompoundStore store) {
        try {
            this.flushTask.call();
            this.shutdown();
            if (this.getDataFile().getAbsolutePath().contains("ehcache_auto_created")) {
                this.indexFile.delete();
                this.delete();
            }
        }
        catch (IOException e) {
            LOG.error("Could not shut down disk cache. Initial cause was " + e.getMessage(), (Throwable)e);
        }
    }

    public Future<Void> flush() {
        return this.schedule(this.flushTask);
    }

    @Override
    protected DiskStorageFactory.DiskMarker createMarker(long position, int size, Element element) {
        return new CachingDiskMarker(this, position, size, element);
    }

    public boolean isInMemory(Object object) {
        return this.inMemoryFilter.allows(object);
    }

    public boolean isOnDisk(Object object) {
        return this.onDiskFilter.allows(object);
    }

    public int getInMemorySize() {
        return this.inMemory.get();
    }

    public long getInMemorySizeInBytes() {
        long size = 0L;
        for (Object o : this.store.getKeys()) {
            Object e = this.store.unretrievedGet(o);
            if (!this.inMemoryFilter.allows(e)) continue;
            size += DiskPersistentStorageFactory.getElement((DiskStorageFactory.DiskSubstitute)e).getSerializedSize();
        }
        return size;
    }

    public int getOnDiskSize() {
        return this.onDisk.get();
    }

    public void setInMemoryCapacity(int capacity) {
        this.memoryCapacity = capacity;
    }

    public void setOnDiskCapacity(int capacity) {
        this.diskCapacity = capacity;
    }

    public void setInMemoryEvictionPolicy(Policy policy) {
        this.memoryPolicy = policy;
    }

    public Policy getInMemoryEvictionPolicy() {
        return this.memoryPolicy;
    }

    private void inMemoryEvict(int size, Object keyHint) {
        if (this.memoryCapacity > 0) {
            CachingDiskMarker target;
            int overflow = size - this.memoryCapacity;
            for (int i = 0; !(i >= Math.min(5, overflow) || (target = this.getMemoryEvictionTarget(keyHint, size)) != null && target.flush() && this.inMemory.decrementAndGet() <= this.memoryCapacity); ++i) {
            }
        }
    }

    private CachingDiskMarker getMemoryEvictionTarget(Object keyHint, int size) {
        List<CachingDiskMarker> sample = this.store.getRandomSample(this.flushableFilter, Math.min(30, size), keyHint);
        CachingDiskMarker target = null;
        for (CachingDiskMarker substitute : sample) {
            if (target == null) {
                target = substitute;
                continue;
            }
            Element targetElement = DiskPersistentStorageFactory.getElement(target);
            Element element = DiskPersistentStorageFactory.getElement(substitute);
            if (targetElement != null && (element == null || !this.memoryPolicy.compare(targetElement, element))) continue;
            target = substitute;
        }
        return target;
    }

    private static final Element getElement(DiskStorageFactory.DiskSubstitute substitute) {
        if (substitute instanceof CachingDiskMarker) {
            return ((CachingDiskMarker)substitute).getCached();
        }
        return ((PersistentPlaceholder)substitute).getElement();
    }

    private void onDiskEvict(int size, Object keyHint) {
        if (this.diskCapacity > 0) {
            DiskStorageFactory.DiskSubstitute target;
            int overflow = size - this.diskCapacity;
            for (int i = 0; !(i >= Math.min(5, overflow) || (target = this.getDiskEvictionTarget(keyHint, size)) != null && this.store.evict(target.getKey(), target) && this.onDisk.get() <= this.diskCapacity); ++i) {
            }
        }
    }

    private DiskStorageFactory.DiskSubstitute getDiskEvictionTarget(Object keyHint, int size) {
        List<CachingDiskMarker> sample = this.store.getRandomSample(this.onDiskFilter, Math.min(30, size), keyHint);
        CachingDiskMarker target = null;
        for (CachingDiskMarker substitute : sample) {
            if (target != null && substitute.getHitCount() >= target.getHitCount()) continue;
            target = substitute;
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIndex() {
        block14: {
            if (!this.indexFile.exists()) {
                return;
            }
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.indexFile));
                try {
                    Object key = ois.readObject();
                    Object value = ois.readObject();
                    if (key instanceof Map && value instanceof List) {
                        LOG.info("Loading old format index file.");
                        this.loadOldIndex((Map)key);
                        break block14;
                    }
                    CachingDiskMarker marker = (CachingDiskMarker)value;
                    while (true) {
                        marker.bindFactory(this);
                        if (!this.store.putRawIfAbsent(key, marker)) {
                            throw new AssertionError();
                        }
                        this.onDisk.incrementAndGet();
                        this.markUsed(marker);
                        key = ois.readObject();
                        marker = (CachingDiskMarker)ois.readObject();
                    }
                }
                finally {
                    ois.close();
                }
            }
            catch (EOFException e) {
                return;
            }
            catch (Exception e) {
                LOG.warn("Index file {} is corrupt, deleting and ignoring it : {}", (Object)this.indexFile, (Object)e);
                e.printStackTrace();
                this.store.removeAll();
                this.indexFile.delete();
            }
            finally {
                this.shrinkDataFile();
            }
        }
    }

    private void loadOldIndex(Map<Object, DiskStore.DiskElement> elements) {
        for (Map.Entry<Object, DiskStore.DiskElement> entry : elements.entrySet()) {
            CachingDiskMarker marker;
            Object key = entry.getKey();
            if (!this.store.putRawIfAbsent(key, marker = new CachingDiskMarker(this, entry.getValue()))) {
                throw new AssertionError();
            }
            this.onDisk.incrementAndGet();
            this.markUsed(marker);
        }
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    private static final class CachingDiskMarker
    extends DiskStorageFactory.DiskMarker
    implements Serializable {
        private static final long serialVersionUID = 43L;
        private static final AtomicReferenceFieldUpdater<CachingDiskMarker, Element> CACHED_UPDATER = AtomicReferenceFieldUpdater.newUpdater(CachingDiskMarker.class, Element.class, "cached");
        private volatile transient Element cached;
        private volatile long expiry;

        CachingDiskMarker(DiskPersistentStorageFactory factory, long position, int size, Element element) {
            super(factory, position, size, element);
            this.expiry = element.getExpirationTime();
        }

        CachingDiskMarker(DiskPersistentStorageFactory factory, DiskStore.DiskElement element) {
            super(factory, element.getPosition(), element.getSize(), element.getObjectKey(), element.getHitCount());
            this.expiry = element.getExpiry();
        }

        boolean cache(Element element) {
            return CACHED_UPDATER.compareAndSet(this, null, element);
        }

        boolean flush() {
            Element old = CACHED_UPDATER.getAndSet(this, null);
            if (old != null) {
                this.expiry = old.getExpirationTime();
                return true;
            }
            return false;
        }

        Element getCached() {
            return CACHED_UPDATER.get(this);
        }

        boolean isCaching() {
            return this.getCached() != null;
        }

        long getExpirationTime() {
            Element e = this.getCached();
            return e == null ? this.expiry : e.getExpirationTime();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FlushableFilter
    implements ElementSubstituteFilter<CachingDiskMarker> {
        private FlushableFilter() {
        }

        @Override
        public boolean allows(Object object) {
            if (!DiskPersistentStorageFactory.this.created(object)) {
                return false;
            }
            return object instanceof CachingDiskMarker && ((CachingDiskMarker)object).isCaching();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InMemoryFilter
    implements ElementSubstituteFilter<DiskStorageFactory.DiskSubstitute> {
        private InMemoryFilter() {
        }

        @Override
        public boolean allows(Object object) {
            if (!DiskPersistentStorageFactory.this.created(object)) {
                return false;
            }
            if (object instanceof PersistentPlaceholder) {
                return true;
            }
            if (object instanceof CachingDiskMarker) {
                return ((CachingDiskMarker)object).isCaching();
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IndexWriteTask
    implements Callable<Void> {
        private final File index;
        private final boolean clearOnFlush;

        IndexWriteTask(File index, boolean clear) {
            this.index = index;
            this.clearOnFlush = clear;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Void call() throws IOException {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.index));
            try {
                for (Object key : DiskPersistentStorageFactory.this.store.keySet()) {
                    Object o = DiskPersistentStorageFactory.this.store.unretrievedGet(key);
                    if (o instanceof PersistentPlaceholder && (o = new PersistentDiskWriteTask((PersistentPlaceholder)o).call()) == null) {
                        o = DiskPersistentStorageFactory.this.store.unretrievedGet(key);
                    }
                    if (!(o instanceof CachingDiskMarker)) continue;
                    CachingDiskMarker marker = (CachingDiskMarker)o;
                    if (this.clearOnFlush && marker.flush()) {
                        DiskPersistentStorageFactory.this.inMemory.decrementAndGet();
                    }
                    oos.writeObject(key);
                    oos.writeObject(marker);
                }
            }
            finally {
                oos.close();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OnDiskFilter
    implements ElementSubstituteFilter<CachingDiskMarker> {
        private OnDiskFilter() {
        }

        @Override
        public boolean allows(Object object) {
            if (!DiskPersistentStorageFactory.this.created(object)) {
                return false;
            }
            if (object instanceof CachingDiskMarker) {
                return !((CachingDiskMarker)object).isCaching();
            }
            return false;
        }
    }

    private final class PersistentDiskWriteTask
    extends DiskStorageFactory.DiskWriteTask {
        PersistentDiskWriteTask(PersistentPlaceholder p) {
            super(p);
        }

        public CachingDiskMarker call() {
            CachingDiskMarker result = (CachingDiskMarker)super.call();
            int disk = DiskPersistentStorageFactory.this.onDisk.incrementAndGet();
            DiskPersistentStorageFactory.this.onDiskEvict(disk, this.getPlaceholder().getKey());
            if (result != null && result.cache(this.getPlaceholder().getElement())) {
                int memory = DiskPersistentStorageFactory.this.inMemory.incrementAndGet();
                DiskPersistentStorageFactory.this.inMemoryEvict(memory, this.getPlaceholder().getKey());
            }
            return result;
        }
    }

    private final class PersistentPlaceholder
    extends DiskStorageFactory.Placeholder {
        PersistentPlaceholder(Element element) {
            super(DiskPersistentStorageFactory.this, element);
        }

        public void installed() {
            DiskPersistentStorageFactory.this.schedule(new PersistentDiskWriteTask(this));
        }
    }
}

