/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.action;

import com.sun.faces.action.RequestMapping;
import com.sun.faces.action.RequestMappingInfo;
import com.sun.faces.lifecycle.Phase;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.util.AnnotationLiteral;
import javax.faces.FacesException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionPhase
extends Phase {
    private BeanManager beanManager;

    public BeanManager getBeanManager() {
        if (this.beanManager == null) {
            Object result = null;
            try {
                InitialContext initialContext = new InitialContext();
                result = initialContext.lookup("java:comp/BeanManager");
            }
            catch (NamingException exception) {
                try {
                    InitialContext initialContext = new InitialContext();
                    result = initialContext.lookup("java:comp/env/BeanManager");
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            this.beanManager = result != null ? (BeanManager)result : null;
        }
        return this.beanManager;
    }

    @Override
    public void execute(FacesContext context) throws FacesException {
        Set beans = this.getBeanManager().getBeans(Object.class, new Annotation[]{new AnnotationLiteral<Any>(){}});
        Iterator beanIterator = beans.iterator();
        RequestMappingInfo current = null;
        while (beanIterator.hasNext()) {
            Bean bean = (Bean)beanIterator.next();
            RequestMappingInfo info = this.findMethodRequestMapping(context, bean);
            if (current == null) {
                current = info;
                continue;
            }
            if (info == null || info.getLength() <= current.getLength()) continue;
            current = info;
        }
        String viewId = null;
        if (current != null) {
            Instance instance = CDI.current().select(current.getBean().getBeanClass(), new Annotation[]{new AnnotationLiteral<Any>(){}});
            try {
                viewId = (String)current.getMethod().invoke(instance.get(), new Object[0]);
            }
            catch (Throwable throwable) {
                throw new FacesException(throwable);
            }
            if (context.getViewRoot() == null) {
                UIViewRoot viewRoot = new UIViewRoot();
                viewRoot.setRenderKitId("HTML_BASIC");
                viewRoot.setViewId(viewId);
                context.setViewRoot(viewRoot);
            }
        }
    }

    @Override
    public PhaseId getId() {
        return PhaseId.ANY_PHASE;
    }

    private RequestMappingInfo findMethodRequestMapping(FacesContext context, Bean<?> bean) {
        RequestMappingInfo result = null;
        Class clazz = bean.getBeanClass();
        AnnotatedType annotatedType = this.beanManager.createAnnotatedType(clazz);
        Set annotatedMethodSet = annotatedType.getMethods();
        for (AnnotatedMethod method : annotatedMethodSet) {
            if (method.isAnnotationPresent(RequestMapping.class)) {
                RequestMapping requestMapping = (RequestMapping)method.getAnnotation(RequestMapping.class);
                String[] mappings = requestMapping.value();
                String mapping = null;
                for (String current : mappings) {
                    String pathInfo = context.getExternalContext().getRequestPathInfo();
                    if (pathInfo.equals(current)) {
                        result = new RequestMappingInfo();
                        result.setBean(bean);
                        result.setMethod(method.getJavaMember());
                        result.setRequestMapping(mapping);
                        result.setMappingType(RequestMappingInfo.MappingType.EXACT);
                        break;
                    }
                    if (current.endsWith("*")) {
                        if (!pathInfo.startsWith(current = current.substring(0, current.length() - 1))) continue;
                        if (result == null) {
                            result = new RequestMappingInfo();
                            result.setBean(bean);
                            result.setMethod(method.getJavaMember());
                            result.setRequestMapping(current);
                            result.setMappingType(RequestMappingInfo.MappingType.PREFIX);
                            continue;
                        }
                        if (current.length() <= result.getLength()) continue;
                        result.setBean(bean);
                        result.setMethod(method.getJavaMember());
                        result.setRequestMapping(current);
                        result.setMappingType(RequestMappingInfo.MappingType.PREFIX);
                        continue;
                    }
                    if (!current.startsWith("*") || !pathInfo.endsWith(current = current.substring(1))) continue;
                    result = new RequestMappingInfo();
                    result.setBean(bean);
                    result.setMethod(method.getJavaMember());
                    result.setRequestMapping(current);
                    result.setMappingType(RequestMappingInfo.MappingType.EXTENSION);
                    break;
                }
            }
            if (result == null || !result.getMappingType().equals((Object)RequestMappingInfo.MappingType.EXACT) && !result.getMappingType().equals((Object)RequestMappingInfo.MappingType.EXTENSION)) continue;
            break;
        }
        return result;
    }
}

