/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring.jmx;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.monitoring.jmx.MBeanExposer;
import org.glassfish.jersey.server.monitoring.ApplicationMXBean;
import org.glassfish.jersey.server.monitoring.ApplicationStatistics;

public class ApplicationMXBeanImpl
implements ApplicationMXBean {
    private final String applicationName;
    private final String applicationClass;
    private final Map<String, String> configurationProperties;
    private final Date startTime;
    private final Set<String> providers = Sets.newHashSet();
    private final Set<String> registeredClasses = Sets.newHashSet();
    private final Set<String> registeredInstances = Sets.newHashSet();

    public ApplicationMXBeanImpl(ApplicationStatistics applicationStatistics, MBeanExposer mBeanExposer, String parentName) {
        for (Class<?> provider : applicationStatistics.getProviders()) {
            this.providers.add(provider.getName());
        }
        for (Class<?> registeredClass : applicationStatistics.getRegisteredClasses()) {
            this.registeredClasses.add(registeredClass.toString());
        }
        for (Object registeredInstance : applicationStatistics.getRegisteredInstances()) {
            this.registeredInstances.add(registeredInstance.getClass().getName());
        }
        ResourceConfig resourceConfig = applicationStatistics.getResourceConfig();
        this.applicationName = resourceConfig.getApplicationName();
        this.applicationClass = resourceConfig.getApplication().getClass().getName();
        this.configurationProperties = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : resourceConfig.getProperties().entrySet()) {
            String stringValue;
            Object value = entry.getValue();
            try {
                stringValue = value == null ? "[null]" : value.toString();
            }
            catch (Exception e) {
                stringValue = LocalizationMessages.PROPERTY_VALUE_TOSTRING_THROWS_EXCEPTION(e.getClass().getName(), e.getMessage());
            }
            this.configurationProperties.put(entry.getKey(), stringValue);
        }
        this.startTime = new Date(applicationStatistics.getStartTime().getTime());
        mBeanExposer.registerMBean(this, parentName + ",global=Configuration");
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public String getApplicationClass() {
        return this.applicationClass;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.configurationProperties;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public Set<String> getRegisteredClasses() {
        return this.registeredClasses;
    }

    @Override
    public Set<String> getRegisteredInstances() {
        return this.registeredInstances;
    }

    @Override
    public Set<String> getProviderClasses() {
        return this.providers;
    }
}

