/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.jetty;

import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import org.jboss.weld.environment.Container;
import org.jboss.weld.environment.ContainerContext;
import org.jboss.weld.environment.jetty.AbstractJettyContainer;
import org.jboss.weld.environment.jetty.JettyWeldInjector;
import org.jboss.weld.environment.servlet.util.Reflections;
import org.jboss.weld.manager.api.WeldManager;

public class JettyContainer
extends AbstractJettyContainer {
    public static Container INSTANCE = new JettyContainer();
    private static final String JETTY_REQUIRED_CLASS_NAME = "org.eclipse.jetty.servlet.ServletHandler";
    private static final int MAJOR_VERSION = 7;
    private static final int MINOR_VERSION = 2;

    @Override
    protected String classToCheck() {
        return JETTY_REQUIRED_CLASS_NAME;
    }

    @Override
    public boolean touch(ContainerContext context) throws Exception {
        ServletContext sc = context.getServletContext();
        String si = sc.getServerInfo();
        int p = si.indexOf("/");
        if (p < 0) {
            return false;
        }
        String version = si.substring(p + 1);
        String[] split = version.split("\\.");
        int major = Integer.parseInt(split[0]);
        int minor = Integer.parseInt(split[1]);
        return major > 7 || major == 7 & minor >= 2;
    }

    @Override
    public void initialize(ContainerContext context) {
        try {
            Class clazz = Reflections.classForName(JettyWeldInjector.class.getName());
            Object injector = clazz.getConstructor(WeldManager.class).newInstance(context.getManager());
            context.getServletContext().setAttribute("org.jboss.weld.environment.jetty.JettyWeldInjector", injector);
            Class decoratorClass = Reflections.classForName("org.jboss.weld.environment.jetty.WeldDecorator");
            Method processMethod = decoratorClass.getMethod("process", ServletContext.class);
            processMethod.invoke(null, context.getServletContext());
            this.log.info("Jetty 7.2+ detected, CDI injection will be available in Listeners, Servlets and Filters.");
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to create JettyWeldInjector. CDI injection will not be available in Servlets, Filters or Listeners", e);
        }
    }
}

