/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.OperatorNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class UnaryOperatorNode
extends OperatorNode {
    String operator;
    String methodName;
    private int operatorType;
    String resultInterfaceType;
    String receiverInterfaceType;
    ValueNode operand;
    public static final int XMLPARSE_OP = 0;
    public static final int XMLSERIALIZE_OP = 1;
    static final String[] UnaryOperators = new String[]{"xmlparse", "xmlserialize"};
    static final String[] UnaryMethodNames = new String[]{"XMLParse", "XMLSerialize"};
    static final String[] UnaryResultTypes = new String[]{"org.apache.derby.iapi.types.XMLDataValue", "org.apache.derby.iapi.types.StringDataValue"};
    static final String[] UnaryArgTypes = new String[]{"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.XMLDataValue"};
    private Object[] additionalArgs;

    public void init(Object object, Object object2, Object object3) {
        this.operand = (ValueNode)object;
        if (object2 instanceof String) {
            this.operator = (String)object2;
            this.methodName = (String)object3;
            this.operatorType = -1;
        } else {
            this.operatorType = (Integer)object2;
            this.operator = UnaryOperators[this.operatorType];
            this.methodName = UnaryMethodNames[this.operatorType];
            this.resultInterfaceType = UnaryResultTypes[this.operatorType];
            this.receiverInterfaceType = UnaryArgTypes[this.operatorType];
            this.additionalArgs = (Object[])object3;
        }
    }

    public void init(Object object) {
        this.operand = (ValueNode)object;
        this.operatorType = -1;
    }

    void setOperator(String string) {
        this.operator = string;
        this.operatorType = -1;
    }

    String getOperatorString() {
        return this.operator;
    }

    void setMethodName(String string) {
        this.methodName = string;
        this.operatorType = -1;
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    public ValueNode getOperand() {
        return this.operand;
    }

    public ParameterNode getParameterOperand() throws StandardException {
        if (!this.requiresTypeFromContext()) {
            return null;
        }
        UnaryOperatorNode unaryOperatorNode = this;
        while (!(unaryOperatorNode.getOperand() instanceof ParameterNode)) {
            unaryOperatorNode = (UnaryOperatorNode)unaryOperatorNode.getOperand();
        }
        return (ParameterNode)unaryOperatorNode.getOperand();
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List list) throws StandardException {
        this.bindOperand(fromList, subqueryList, list);
        if (this.operatorType == 0) {
            this.bindXMLParse();
        } else if (this.operatorType == 1) {
            this.bindXMLSerialize();
        }
        return this;
    }

    protected void bindOperand(FromList fromList, SubqueryList subqueryList, List list) throws StandardException {
        this.operand = this.operand.bindExpression(fromList, subqueryList, list);
        if (this.operand.requiresTypeFromContext()) {
            this.bindParameter();
            if (this.operand.getTypeServices() == null) {
                return;
            }
        }
        if (!(this.operand instanceof UntypedNullConstantNode) && this.operand.getTypeId().userType() && !(this instanceof IsNullNode)) {
            this.operand = this.operand.genSQLJavaSQLTree();
        }
    }

    private void bindXMLParse() throws StandardException {
        TypeId typeId = this.operand.getTypeId();
        if (typeId != null) {
            switch (typeId.getJDBCTypeId()) {
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    break;
                }
                default: {
                    throw StandardException.newException("42X25", (Object)this.methodName, (Object)typeId.getSQLTypeName());
                }
            }
        }
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(2009));
    }

    private void bindXMLSerialize() throws StandardException {
        TypeId typeId = this.operand.getTypeId();
        if (typeId != null && !typeId.isXMLTypeId()) {
            throw StandardException.newException("42X25", (Object)this.methodName, (Object)typeId.getSQLTypeName());
        }
        DataTypeDescriptor dataTypeDescriptor = (DataTypeDescriptor)this.additionalArgs[0];
        TypeId typeId2 = dataTypeDescriptor.getTypeId();
        switch (typeId2.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            default: {
                throw StandardException.newException("42Z73", typeId2.getSQLTypeName());
            }
        }
        this.setType(dataTypeDescriptor);
        this.setCollationUsingCompilationSchema();
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        if (this.operand != null) {
            this.operand = this.operand.preprocess(n, fromList, subqueryList, predicateList);
        }
        return this;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        return this.operand == null ? false : this.operand.categorize(jBitSet, bl);
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.operand != null) {
            this.operand = this.operand.remapColumnReferencesToExpressions();
        }
        return this;
    }

    public boolean isConstantExpression() {
        return this.operand == null ? true : this.operand.isConstantExpression();
    }

    public boolean constantExpression(PredicateList predicateList) {
        return this.operand == null ? true : this.operand.constantExpression(predicateList);
    }

    void bindParameter() throws StandardException {
        if (this.operatorType == 0) {
            throw StandardException.newException("42Z79");
        }
        if (this.operatorType == 1) {
            throw StandardException.newException("42Z70");
        }
        if (this.operand.getTypeServices() == null) {
            throw StandardException.newException("42X36", this.operator);
        }
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        String string = this.operatorType == -1 ? this.getTypeCompiler().interfaceName() : this.resultInterfaceType;
        boolean bl = !this.getTypeId().isBooleanTypeId();
        String string2 = this.getReceiverInterfaceName();
        this.operand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.cast(string2);
        if (bl) {
            LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string);
            methodBuilder.getField(localField);
            int n = 1;
            methodBuilder.callMethod((short)185, null, this.methodName, string, n += this.addXmlOpMethodParams(expressionClassBuilder, methodBuilder, localField));
            methodBuilder.putField(localField);
        } else {
            methodBuilder.callMethod((short)185, null, this.methodName, string, 0);
        }
    }

    public String getReceiverInterfaceName() throws StandardException {
        if (this.operatorType != -1) {
            return this.receiverInterfaceType;
        }
        return this.operand.getTypeCompiler().interfaceName();
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.operand != null ? this.operand.getOrderableVariantType() : 3;
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.operand != null) {
            this.operand = (ValueNode)this.operand.accept(visitor);
        }
    }

    protected int addXmlOpMethodParams(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, LocalField localField) throws StandardException {
        if (this.operatorType != 0 && this.operatorType != 1) {
            return 0;
        }
        if (this.operatorType == 1) {
            DataTypeDescriptor dataTypeDescriptor = (DataTypeDescriptor)this.additionalArgs[0];
            methodBuilder.push(dataTypeDescriptor.getJDBCTypeId());
            methodBuilder.push(dataTypeDescriptor.getMaximumWidth());
            methodBuilder.push(this.getSchemaDescriptor(null, false).getCollationType());
            return 3;
        }
        MethodBuilder methodBuilder2 = expressionClassBuilder.getConstructor();
        expressionClassBuilder.generateNull(methodBuilder2, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        methodBuilder2.setField(localField);
        methodBuilder.swap();
        methodBuilder.push((Boolean)this.additionalArgs[0]);
        UnaryOperatorNode.pushSqlXmlUtil(expressionClassBuilder, methodBuilder, null, null);
        return 2;
    }

    protected boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (this.isSameNodeType(valueNode)) {
            UnaryOperatorNode unaryOperatorNode = (UnaryOperatorNode)valueNode;
            return this.operator.equals(unaryOperatorNode.operator) && (this.operand == unaryOperatorNode.operand || this.operand != null && this.operand.isEquivalent(unaryOperatorNode.operand));
        }
        return false;
    }
}

