/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import javax.transaction.xa.Xid;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetIndoubtTransaction;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.client.net.NetXACallInfo;
import org.apache.derby.client.net.NetXAResource;
import org.apache.derby.jdbc.ClientBaseDataSourceRoot;
import org.apache.derby.jdbc.ClientDriver;

public class NetXAConnection {
    private NetConnection netCon;

    public NetXAConnection(NetLogWriter netLogWriter, String string, String string2, ClientBaseDataSourceRoot clientBaseDataSourceRoot, int n, boolean bl, ClientPooledConnection clientPooledConnection) throws SqlException {
        this.netCon = this.createNetConnection(netLogWriter, string, string2, clientBaseDataSourceRoot, n, bl, clientPooledConnection);
        this.checkPlatformVersion();
    }

    protected void finalize() throws Throwable {
        this.netCon.finalize();
    }

    public void setCorrelatorToken(byte[] byArray) {
        this.netCon.crrtkn_ = byArray;
    }

    public byte[] getCorrelatorToken() {
        return this.netCon.crrtkn_;
    }

    void setNetXAResource(NetXAResource netXAResource) {
        this.netCon.xares_ = netXAResource;
    }

    public void writeLocalXAStart_() throws SqlException {
        this.netCon.netAgent_.netConnectionRequest_.writeLocalXAStart(this.netCon);
    }

    public void readLocalXAStart_() throws SqlException {
        this.netCon.netAgent_.netConnectionReply_.readLocalXAStart(this.netCon);
    }

    public void writeLocalXACommit_() throws SqlException {
        this.netCon.netAgent_.netConnectionRequest_.writeLocalXACommit(this.netCon);
    }

    public void readLocalXACommit_() throws SqlException {
        this.netCon.netAgent_.netConnectionReply_.readLocalXACommit(this.netCon);
    }

    public void writeLocalXARollback_() throws SqlException {
        this.netCon.netAgent_.netConnectionRequest_.writeLocalXARollback(this.netCon);
    }

    public void readLocalXARollback_() throws SqlException {
        this.netCon.netAgent_.netConnectionReply_.readLocalXARollback(this.netCon);
    }

    public void writeTransactionStart(Statement statement) throws SqlException {
        if (!this.netCon.isXAConnection()) {
            return;
        }
        int n = this.netCon.getXAState();
        this.netCon.xares_.exceptionsOnXA = null;
    }

    public byte[] getUOWID(Xid xid) {
        NetIndoubtTransaction netIndoubtTransaction = (NetIndoubtTransaction)this.netCon.indoubtTransactions_.get(xid);
        if (netIndoubtTransaction == null) {
            return null;
        }
        byte[] byArray = netIndoubtTransaction.getUOWID();
        return byArray;
    }

    public int getPort(Xid xid) {
        NetIndoubtTransaction netIndoubtTransaction = (NetIndoubtTransaction)this.netCon.indoubtTransactions_.get(xid);
        if (netIndoubtTransaction == null) {
            return -1;
        }
        return netIndoubtTransaction.getPort();
    }

    public void writeCommit() throws SqlException {
        int n = this.netCon.getXAState();
        if (n == 0) {
            this.netCon.xares_.callInfoArray_[this.netCon.xares_.conn_.currXACallInfoOffset_].xid_ = NetXAResource.nullXid;
            this.writeLocalXACommit_();
        }
    }

    public void readCommit() throws SqlException {
        int n = this.netCon.getXAState();
        NetXACallInfo netXACallInfo = this.netCon.xares_.callInfoArray_[this.netCon.currXACallInfoOffset_];
        netXACallInfo.xaRetVal_ = 0;
        if (n == 0) {
            this.readLocalXACommit_();
        }
        if (netXACallInfo.xaRetVal_ != 0) {
            netXACallInfo.xaFunction_ = 1;
            this.netCon.xares_.xaRetValErrorAccumSQL(netXACallInfo, 0);
            netXACallInfo.xaRetVal_ = 0;
            throw this.netCon.xares_.exceptionsOnXA;
        }
    }

    public void writeRollback() throws SqlException {
        NetXAResource cfr_ignored_0 = this.netCon.xares_;
        this.netCon.xares_.callInfoArray_[this.netCon.xares_.conn_.currXACallInfoOffset_].xid_ = NetXAResource.nullXid;
        this.writeLocalXARollback_();
    }

    public void readRollback() throws SqlException {
        NetXACallInfo netXACallInfo = this.netCon.xares_.callInfoArray_[this.netCon.currXACallInfoOffset_];
        netXACallInfo.xaRetVal_ = 0;
        this.readLocalXARollback_();
        if (netXACallInfo.xaRetVal_ != 0) {
            netXACallInfo.xaFunction_ = 6;
            this.netCon.xares_.xaRetValErrorAccumSQL(netXACallInfo, 0);
            netXACallInfo.xaRetVal_ = 0;
            throw this.netCon.xares_.exceptionsOnXA;
        }
        this.netCon.setXAState(0);
    }

    public NetConnection getNetConnection() {
        return this.netCon;
    }

    private void checkPlatformVersion() throws SqlException {
        int n = 8;
        if (this.netCon.xaHostVersion_ >= n) {
            return;
        }
        String string = null;
        string = "Linux, Unix, Windows";
        throw new SqlException(this.netCon.agent_.logWriter_, new ClientMessageId("XN012.S"), (Object)string, (Object)n, (Object)this.netCon.xaHostVersion_);
    }

    protected NetConnection createNetConnection(NetLogWriter netLogWriter, String string, String string2, ClientBaseDataSourceRoot clientBaseDataSourceRoot, int n, boolean bl, ClientPooledConnection clientPooledConnection) throws SqlException {
        return (NetConnection)ClientDriver.getFactory().newNetConnection(netLogWriter, string, string2, clientBaseDataSourceRoot, n, bl, clientPooledConnection);
    }
}

