/*
 * Copyright 2011 Oracle and/or its affiliates.
 * All rights reserved.  You may not modify, use,
 * reproduce, or distribute this software except in
 * compliance with  the terms of the License at:
 * http://developers.sun.com/license/berkeley_license.html
 */


package mood.web;

import java.util.logging.Logger;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;


/**
 * Listener cyklu życia aplikacji internetowej.
 */
@WebListener()
public class SimpleServletListener implements ServletContextListener,
    ServletContextAttributeListener {
    static final Logger log = Logger.getLogger(
                "mood.web.SimpleServletListener");

    public void contextInitialized(ServletContextEvent sce) {
        log.info("Kontekst zainicjalizowany");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        log.info("Kontekst usunięty");
    }

    public void attributeAdded(ServletContextAttributeEvent event) {
        log.info(
                "Atrybut " + event.getName()
                + " został dodany z wartością: " + event.getValue());
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        log.info("Atrybut " + event.getName() + " został usunięty");
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        log.info(
                "Atrybut " + event.getName()
                + " został zastąpiony wartością: " + event.getValue());
    }
}
