/*
 * Copyright 2011 Oracle and/or its affiliates.
 * All rights reserved.  You may not modify, use,
 * reproduce, or distribute this software except in
 * compliance with  the terms of the License at:
 * http://developers.sun.com/license/berkeley_license.html
 */


package mood.web;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


@WebServlet("/report")
public class MoodServlet extends HttpServlet {
    /**
     * Przetwarza żądania dla obu metod HTTP: <code>GET</code> i <code>POST</code>.
     * @param request żądanie przychodzące do serwletu
     * @param response odpowiedź serwletu
     * @throws ServletException jeśli wystapi jakikolwiek błąd charakterystyczny dla serwletu
     * @throws IOException jeśli wystąpi błąd wejścia/wyjścia
     */
    protected void processRequest(
        HttpServletRequest request,
        HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");

        PrintWriter out = response.getWriter();

        try {
            out.println("<html lang=\"pl\">");
            out.println("<head>");
            out.println("<title>Serwlet MoodServlet</title>");
            out.println("</head>");
            out.println("<body>");
            out.println(
                    "<h1>Serwlet MoodServlet na " + request.getContextPath()
                    + "</h1>");

            String mood = (String) request.getAttribute("nastroj");
            out.println("<p>Nastrój Duke'a: " + mood + "</p>");

            if (mood.equals("śpiący")) {
                out.println(
                        "<img src=\"images/duke.snooze.gif\" alt=\"Śpiący Duke\"/><br/>");
            } else if (mood.equals("czujny")) {
                out.println(
                        "<img src=\"images/duke.waving.gif\" alt=\"Machający Duke\"/><br/>");
            } else if (mood.equals("głodny")) {
                out.println(
                        "<img src=\"images/duke.cookies.gif\" alt=\"Duke z ciasteczkami\"/><br/>");
            } else if (mood.equals("apatyczny")) {
                out.println(
                        "<img src=\"images/duke.handsOnHips.gif\" alt=\"Duke z rękami na biodrach\"/><br/>");
            } else if (mood.equals("zamyślony")) {
                out.println(
                        "<img src=\"images/duke.pensive.gif\" alt=\"Myślący Duke\"/><br/>");
            } else {
                out.println(
                        "<img src=\"images/duke.thumbsup.gif\" alt=\"Duke z kciukiem w górze\"/><br/>");
            }

            out.println("</body>");
            out.println("</html>");
        } finally {
            out.close();
        }
    }

    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /**
     * Obsługuje metodę HTTP <code>GET</code>.
     * @param request żądanie przychodzące do serwletu
     * @param response odpowiedź serwletu
     * @throws ServletException jeśli wystapi jakikolwiek błąd charakterystyczny dla serwletu
     * @throws IOException jeśli wystąpi błąd wejścia/wyjścia
     */
    @Override
    protected void doGet(
        HttpServletRequest request,
        HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        processRequest(request, response);
    }

    /**
     * Obsługuje metodę HTTP <code>POST</code>.
     * @param request żądanie przychodzące do serwletu
     * @param response odpowiedź serwletu
     * @throws ServletException jeśli wystapi jakikolwiek błąd charakterystyczny dla serwletu
     * @throws IOException jeśli wystąpi błąd wejścia/wyjścia
     */
    @Override
    protected void doPost(
        HttpServletRequest request,
        HttpServletResponse response) throws ServletException, IOException {
        processRequest(request, response);
    }

    /**
     * Zwraca krótki opis serwletu.
     * @return łańcuch znaków zawierający opis serwletu
     */
    @Override
    public String getServletInfo() {
        return "Krótki opis";
    } // </editor-fold>
}
