/*
 * Copyright 2011 Oracle and/or its affiliates.
 * All rights reserved.  You may not modify, use,
 * reproduce, or distribute this software except in
 * compliance with  the terms of the License at:
 * http://developers.sun.com/license/berkeley_license.html
 */


package rsvp.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;


@NamedQuery(name = "rsvp.entity.Event.getAllUpcomingEvents", query = "SELECT e FROM Event e ")
@Entity
public class Event implements Serializable {
    private static final long serialVersionUID = 1L;
    @ManyToMany
    protected List<Person> invitees;
    protected String location;
    protected String name;
    @Temporal(javax.persistence.TemporalType.DATE)
    private Date eventDate;
    @OneToMany(mappedBy = "event")
    private List<Response> responses;
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;
    @ManyToOne
    private Person owner;

    public Event() {
        this.invitees = new ArrayList<Person>();
        this.responses = new ArrayList<Response>();
    }

    /**
     * Pobiera wartość pola location zawierajacego miejsce wydarzenia
     *
     * @return wartość pola location
     */
    public String getLocation() {
        return location;
    }

    /**
     * Ustawia wartość pola location zawierajacego miejsce wydarzenia
     *
     * @param location nowa wartość pola location
     */
    public void setLocation(String location) {
        this.location = location;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /**
     * Pobiera wartość pola name zawierajacego nazwę wydarzenia
     *
     * @return wartość pola name
     */
    public String getName() {
        return name;
    }

    /**
     * Ustawia wartość pola name zawierajacego nazwę wydarzenia
     *
     * @param name nowa wartość pola name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Pobiera wartość pola invitees zawierajacego zaproszone osoby
     *
     * @return wartość pola invitees
     */
    public List<Person> getInvitees() {
        return invitees;
    }

    /**
     * Ustawia wartość pola invitees zawierajacego zaproszone osoby
     *
     * @param invitees nowa wartość pola invitees
     */
    public void setInvitees(List<Person> invitees) {
        this.invitees = invitees;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += ((id != null) ? id.hashCode() : 0);

        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Uwaga - ta metoda nie zadziała jeśli wartości pól id nie zostały ustawione
        if (!(object instanceof Event)) {
            return false;
        }

        Event other = (Event) object;

        if (((this.id == null) && (other.id != null))
                || ((this.id != null) && !this.id.equals(other.id))) {
            return false;
        }

        return true;
    }

    @Override
    public String toString() {
        return "rsvp.entity.Event[id=" + id + "]";
    }

    /**
     * @return odpowiedzi
     */
    public List<Response> getResponses() {
        return responses;
    }

    /**
     * @param responses ustawiane odpowiedzi
     */
    public void setResponses(List<Response> responses) {
        this.responses = responses;
    }

    /**
     * @return data wydarzenia
     */
    public Date getEventDate() {
        return eventDate;
    }

    /**
     * @param eventDate ustawiana data wydarzenia
     */
    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    /**
     * @return właściciel
     */
    public Person getOwner() {
        return owner;
    }

    /**
     * @param owner ustawiany właściciel
     */
    public void setOwner(Person owner) {
        this.owner = owner;
    }
}
