// Szkic biblioteki dostawcy usug

import java.util.*;
import java.util.concurrent.*;

// Klasa nie niekonkretyzowana dla rejestracji usug i dostpu
public class Services {
    private Services() { } // Zabezpiecza przed konkretyzacj (temat 4)
    
    // Odwzorowanie nazw usug na usugi
    private static final Map<String, Provider> providers =
        new ConcurrentHashMap<String, Provider>();
    public static final String DEFAULT_PROVIDER_NAME = "<def>";
    
    // API rejestracji dostawcy
    public static void registerDefaultProvider(Provider p) {
        registerProvider(DEFAULT_PROVIDER_NAME, p);
    }
    public static void registerProvider(String name, Provider p){
        providers.put(name, p);
    }
    
    // API dostpu do usugi
    public static Service newInstance() {
        return newInstance(DEFAULT_PROVIDER_NAME);
    }
    
    public static Service newInstance(String name) {
        Provider p = providers.get(name);
        if (p == null)
            throw new IllegalArgumentException(
                "Brak zarejestrowanego dostawcy o nazwie: " + name);
        return p.newService();
    }
}
