import static java.lang.System.out;
import java.util.Scanner;
import java.text.NumberFormat;

public class InventoryD {

   public static void main(String args[]) {
       final double boxPrice = 3.25;
       Scanner keyboard = new Scanner(System.in);
       NumberFormat currency = NumberFormat.getCurrencyInstance();

       out.print("Ile mamy pudeek? ");
       String numBoxesIn = keyboard.next();

       try {
           int numBoxes = Integer.parseInt(numBoxesIn);

           if (numBoxes < 0) {
               throw new OutOfRangeException();
           }

           if (numBoxes > 1000) {
               throw new NumberTooLargeException();
           }           
           
           out.print("Ich warto to ");
           out.println(currency.format(numBoxes * boxPrice));
       } 
       
       catch (NumberFormatException e) {
           out.println("To nie jest prawidowa liczba.");
       } 
       
       catch (OutOfRangeException e) {
           out.print(numBoxesIn);
           out.println("? To niemoliwe!");
       }

       catch (Exception e) {
           out.print("Co poszo nie tak, "); 
           out.print("ale nie wiem "); 
           out.println("co to waciwie byo."); 
       }

       out.println("I to wszystko.");

       keyboard.close();
   }
}
