import static java.lang.System.out;
import java.util.Scanner;
import java.text.NumberFormat;

public class InventoryLoop {

   public static void main(String args[]) {
      final double boxPrice = 3.25;
      boolean gotGoodInput = false;
      Scanner keyboard = new Scanner(System.in);
      NumberFormat currency = NumberFormat.getCurrencyInstance();

      do {
         out.print("Ile mamy pudełek? ");
         String numBoxesIn = keyboard.next();

         try {
            int numBoxes = Integer.parseInt(numBoxesIn);
            out.print("Ich wartość to ");
            out.println(currency.format(numBoxes * boxPrice));
            gotGoodInput = true;
         } catch (NumberFormatException e) {
            out.println();
            out.println("To nie jest prawidłowa liczba.");
         }
      } while (!gotGoodInput);

      out.println("I to wszystko.");

      keyboard.close();
   }
}
