// Program P6.4

import java.util.*;
public class Nim {
   public static void main(String[] args) {
      Scanner in = new Scanner(System.in);
      System.out.printf("\nPodaj liczb kamieni na stole: ");
      int remain = in.nextInt();
      System.out.printf("Maksymalna liczba kamieni zdejmowanych w jednym ruch to: ");
      int maxPick = in.nextInt();
      playGame(in, remain, maxPick);
   } //koniec main
 
   public static void playGame(Scanner in, int remain, int maxPick) {
      int userPick;
      System.out.printf("\nNa stole pozostaje %d kamieni.\n", remain);
      while (true) { //ptla wykonywana a do zakoczenia gry
         do {
            System.out.printf("Twoja kolej, ile kamieni zdejmujesz: ");
            userPick = in.nextInt();
            if (userPick > remain)
               System.out.printf("Nie moesz zdj wicej ni %d kamieni.\n", Math.min(remain, maxPick));
            else if (userPick < 1 || userPick > maxPick)
               System.out.printf("Nieprawidowa liczba: wpisz liczb od 1 do %d: ", maxPick);
         } while (userPick > remain || userPick < 1 || userPick > maxPick);
 
         remain = remain - userPick;
         System.out.printf("Na stole pozostaje %d kamieni.\n", remain);
         if (remain == 0) {
            System.out.printf("Przegrae!!\n");  return;
         }
         if (remain == 1) {
            System.out.printf("Wygrae!!\n");  return;
         }
         int compPick = bestPick(remain, maxPick);
         System.out.printf("Zdejmuj ze stou %d kamieni.\n", compPick);
         remain = remain - compPick;
         System.out.printf("Na stole pozostaje %d kamieni.\n", remain);
         if (remain == 0) {
            System.out.printf("Wygrae!!\n");
            return;
         }
         if (remain == 1) {
            System.out.printf("Wygraem!!\n");
            return;
         }
      } //koniec while (true)
   } //koniec playGame
 
   public static int bestPick(int remain, int maxPick) {
      if (remain <= maxPick) return remain - 1; //doprowad do sytuacji przegrywajcej
      int r = remain % (maxPick + 1);
      if (r == 0) return maxPick; //doprowad do sytuacji przegrywajcej
      if (r == 1) return random(1, maxPick); //program w sytuacji przegrywajcej
      return r - 1; //gracz w sytuacji przegrywajcej
   } //koniec bestPick
 
   public static int random(int m, int n) {
   //funkcja zwraca liczb losow z zakresu od m do n, wcznie
      return (int) (Math.random() * (n - m + 1)) + m;
   } //koniec random
 
} //koniec klasy Nim
