//Program P4.8

import java.util.*;
public class QueueTest {
   public static void main(String[] args) {
      Scanner in = new Scanner(System.in);
      Queue Q = new Queue();
      System.out.printf("Wpisz dodatni liczb cakowit: ");
      int n = in.nextInt();
      while (n > 0) {
         Q.enqueue(new NodeData(n % 10));
         n = n / 10;
      }
      System.out.printf("\nCyfry w odwrotnej kolejnoci: ");
      while (!Q.empty())
         System.out.printf("%d", Q.dequeue().getIntData());
      System.out.printf("\n");
   } //koniec main
} //koniec QueueTest

class NodeData {
   int num;
   
   public NodeData(int n) {
      num = n;
   }
   
   public int getIntData() {return num;}
   
} //koniec klasy NodeData

class Node {
   NodeData data;
   Node next;
   
   public Node(NodeData d) {
      data = d;
      next = null;
   }
} //koniec klasy Node

class Queue {
   Node head = null, tail = null;
   
   public boolean empty() {
      return head == null;
   }
   
   public void enqueue(NodeData nd) {
      Node p = new Node(nd);
      if (this.empty()) {
         head = p;
         tail = p;
      }
      else {
         tail.next = p;
         tail = p;
      }
   } //koniec enqueue
   
   public NodeData dequeue() {
      if (this.empty()) {
         System.out.printf("\nPrba usunicia elementu z pustej kolejki!\n");
         System.exit(1);
      }
      NodeData hold = head.data;
      head = head.next;
      if (head == null) tail = null;
      return hold;
   } //koniec dequeue
   
} //koniec klasy Queue
