// Program P3.4

import java.util.*;

public class LinkedListTest {
   public static void main(String[] args) {
      Scanner in = new Scanner(System.in);
      LinkedList LL = new LinkedList();
      System.out.printf("Podaj kilka liczb cakowitych i zakocz wpisywanie 0\n");
      int n = in.nextInt();
      while (n != 0) {
         LL.addInPlace(new NodeData(n));
         n = in.nextInt();
      }
      LL.printList();
   } //koniec main
} //koniec klasy LinkedListTest

class NodeData {
   int num;

   public NodeData(int n) {
      num = n;
   }

   public int compareTo(NodeData nd) {
      if (this.num == nd.num) return 0;
      if (this.num < nd.num) return -1;
      return 1;
   } //koniec compareTo

   public String toString() {
      return num + " ";
      //acuch " " jest potrzebny by skonwertowa num do postaci 
      //acucha znakw; mona take uy "" (acucha pustego)
   }
} //koniec klasy NodeData

class Node {
   NodeData data;

   Node next;
   public Node(NodeData nd) {
      data = nd;
      next = null;
   }
} //koniec klasy Node

class LinkedList {
   Node head = null;

   public boolean empty() {
      return head == null;
   }

   public void addHead(NodeData nd) {
      Node p = new Node(nd);
      p.next = head;
      head = p;
   }

   public void addInPlace(NodeData nd) {
      Node np, curr, prev;
      np = new Node(nd);
      prev = null;
      curr = head;
      while (curr != null && nd.compareTo(curr.data) > 0) { //nowa warto jest wiksza
         prev = curr;
         curr = curr.next;
      }
      np.next = curr;
      if (prev == null) head = np;
      else prev.next = np;
   } //koniec addInPlace

   public void printList() {
      Node curr = head;
      while (curr != null) {
         System.out.printf("%s", curr.data); //wywouje curr.data.toString()
         curr = curr.next;
      }
      System.out.printf("\n");
   } //koniec printList

} //koniec class LinkedList

