//Program P2.2

public class PartTest {
   // program testujcy dziaanie klasy Part

   public static void main(String[] args) {
      Part a, b, c; // deklarujemy 3 zmienne klasy Part 

      // tworzymy 3 obiekty Part
      a = new Part("Filtr powietrza", 80.75);
      b = new Part("cze kulowe", 29.95);
      c = new Part("Lampa przednia", 199.99); // nieprawidowa cena

      a.printPart(); // oczekiwane wyniki Filtr powietrza, 80,75 z
      b.printPart(); // oczekiwane wyniki cze kulowe, 29,95 z
      c.printPart(); // oczekiwane wyniki Lampa przednia, -1.0 z

      c.setPrice(36.99);
      c.printPart(); // oczekiwane wyniki Lampa przednia, 36,99 z

      // wywietlamy sumaryczn liczb czci; oczekiwany wynik to 3
      System.out.printf("\nLiczba czci: %d\n", Part.GetNumParts());
   } //koniec main
} //koniec klasy PartTest

class Part { 
   //stae
   private static final double MinPrice = 0.0;
   private static final double MaxPrice = 99.99;
   private static final double NullPrice = -1.0;

   private static int NumParts = 0;  // zmienna klasowa
   private String name;              // zmienna instancyjna
   private double price;             // zmienna instancyjna

   public Part(String n, double p) {   // konstruktor
      name = n;
      if (p < MinPrice || p > MaxPrice) {
         System.out.printf("Cz: %s\n", name);
         System.out.printf("Nieprawidowa cena: %3.2f. Uywamy wartoci %3.2f\n", p, NullPrice);
         price = -1.0;
      }
      else price = p;
      NumParts++;
   } //koniec konstruktora Part

   public static int GetNumParts() {  // akcesor
      return NumParts;
   }

   public String getName() { // akcesor
      return name;
   }
   public double getPrice() { // akcesor
      return price;
   }

   public void setPrice(double p) {  // mutator
      if (p < MinPrice || p > MaxPrice) {
         System.out.printf("Cz: %s\n", name);
         System.out.printf("Nieprawidowa cena: %3.2f. Uywamy wartoci %3.2f\n", p, NullPrice);
         price = NullPrice;
      }
      else price = p;
   } //koniec setPrice

   public void printPart() {
      System.out.printf("\nNazwa czci: %s\n", name);
      System.out.printf("Cena: %3.2f z\n", price);
   } //koniec printPart

   public String toString() {
      return "\nNazwa czci: " + name + "\nCena: " + price + " z\n";
   }   

   public static void changePrice(Part p, double amount) {
      p.price += amount;
   }   
} // koniec klasy Part