//Program P1.1

import java.util.*;
public class SelectSortTest {
   final static int MaxNumbers = 10;
   public static void main(String[] args) {
      Scanner in = new Scanner(System.in);
      int[] num = new int[10];
      System.out.printf("Wpisz do %d liczb i zakocz podawanie danych wpisujc 0\n", MaxNumbers);
      int n = 0;
      int v = in.nextInt();
      while (v != 0 && n < MaxNumbers) {
         num[n++] = v;
         v = in.nextInt();
      }
      if (v != 0) {
         System.out.printf("\nWpisano wicej ni %d liczb\n", MaxNumbers);
         System.out.printf("Uytych zostanie tylko %d pierwszych liczb\n", MaxNumbers);
      }
      if (n == 0) {
         System.out.printf("\nNie podano adnych liczb\n");
         System.exit(1);
      }
      //n liczb jest przechowywanych w tablicy, w komrkach od num[0] do num[n-1]
      selectionSort(num, 0, n-1);
      System.out.printf("\nPosortowane liczby to:\n");
      for (v = 0; v < n; v++) System.out.printf("%d ", num[v]);
         System.out.printf("\n");
   } //koniec main

   public static void selectionSort(int[] list, int lo, int hi) {
  //sortowanie list[lo] do list[hi] w kolejnoci rosncej
     for (int h = lo; h < hi; h++) {
        int s = getSmallest(list, h, hi);
        swap(list, h, s);
     }
  }

  public static int getSmallest(int list[], int lo, int hi) {
   //zwracamy pooenie najmniejszego elementu z list[lo..hi]
     int small = lo;
     for (int h = lo + 1; h <= hi; h++)
        if (list[h] < list[small]) small = h;
     return small;
  }

  public static void swap(int list[], int i, int j) {
   //zamieniamy elementy list[i] oraz list[j]
     int hold = list[i];
     list[i] = list[j];
     list[j] = hold;
  }
} //koniec klasy SelectSortTest
