// Program P9.1

import java.io.*;
public class HeapSortTest {
   public static void main(String[] args) throws IOException {
      int[] num = {0, 37, 25, 43, 65, 48, 84, 73, 18, 79, 56, 69, 32};
      int n = 12;
      heapSort(num, n);
      for (int h = 1; h <= n; h++) System.out.printf("%d ", num[h]);
      System.out.printf("\n");
   }
      
   public static void heapSort(int[] num, int n) {
   //sortujemy zakres tablicy od num[1] do num[n]
   //przeksztacamy tablic w kopiec
      for (int k = n / 2; k >= 1; k--) siftDown(num[k], num, k, n);
      
      for (int k = n; k > 1; k--) {
         int item = num[k]; //pobieramy aktualnie ostatni element
         num[k] = num[1];   //przenosimy wierzchoek kopca do ostatniebo elementu
         siftDown(item, num, 1, k-1); //odtwarzamy warunek kopca w zakresie 1 do k-1
      }
   } //koniec heapSort
      
   public static void siftDown(int key, int[] num, int root, int last) {
      int bigger = 2 * root;
      while (bigger <= last) { //dopki jest co najmniej jedno dziecko
         if (bigger < last) //istnieje take prawe dziecko; znajdujemy wiksze
            if (num[bigger+1] > num[bigger]) bigger++;
         //'bigger' zawiera indeks wikszego dziecka
         if (key >= num[bigger]) break;
         //warto key jest mniejsza; wybieamy num[bigger]
         num[root] = num[bigger];
         root = bigger;
         bigger = 2 * root;
      }
      num[root] = key;
   } //koniec siftDown
      
} //koniec klasy HeapSortTest
              