// Program P8.3

import java.io.*;
import java.util.*;
public class BinarySearchTreeTest {
   public static void main(String[] args) throws IOException {
    
      Scanner in = new Scanner(new FileReader("words.in"));
    
      BinaryTree bst = new BinaryTree();
    
      in.useDelimiter("[^a-zA-Z]+");
      while (in.hasNext()) {
         String word = in.next().toLowerCase();
         TreeNode node = bst.findOrInsert(new NodeData(word));
      }
      System.out.printf("\n\nPrzejcie drzewa metod in-order: ");
      bst.inOrderTraversal();
      System.out.printf("\n");
      in.close();
   } //koniec main
    
} //koniec klasy BinarySearchTreeTest
    
class NodeData {
   String word;
    
   public NodeData(String w) {
      word = w;
   }
    
   public int compareTo(NodeData d) {
      return this.word.compareTo(d.word);
   }
    
   public void visit() {
      System.out.printf("%s ", word);
   }
} //koniec klasy NodeData
    
class TreeNode {
   NodeData data;
   TreeNode left, right, parent;
    
   public TreeNode(NodeData d) {
      data = d;
      left = right = parent = null;
   }
} //koniec klasy TreeNode
    
// Klasa BinaryTree - przedsatwilimy tu jedynie metody uywane w programie
class BinaryTree {
   TreeNode root;
    
   public BinaryTree() {
      root = null;
   }
   
   public void inOrderTraversal() {
      if (root == null) return;
      //znajdujemy pierwszy wierzchoek w kolejnoci in-order
      TreeNode node = root;
      while (node.left != null) node = node.left;
      while (node != null) {
         node.data.visit(); //z klasy NodeData 
         node = inOrderSuccessor(node);
      }
   } //koniec inOrderTraversal
    
   private static TreeNode inOrderSuccessor(TreeNode node) {
      if (node.right != null) {
         node = node.right;
         while (node.left != null) node = node.left;
         return node;
      }
      //wierzchoek nie ma prawego poddrzewa; szukamy najniszego
      //przodka dla ktrego dany wierzchoek jest w lewym poddrzewie;
      //zwracamy null jeli nie uda si go znale (wierzchoek jest
      //ostatni w porzdku in-order)
      TreeNode parent = node.parent;
      while (parent != null && parent.right == node) {
         node = parent;
         parent = node.parent;
      }
      return parent;
   } //koniec inOrderSuccessor
    
   public TreeNode findOrInsert(NodeData d) {
   //funkcja szuka d w drzewie; jeli znajdzie, to zwraca wskanik na 
   //wierzchoek; w przeciwnym razie dodaje d i zwraca wskak na nowy
   //wierzchoek; w polu parent d zostaje zapisany wskanik na jego rodzica
      TreeNode curr, node;
      int cmp;
    
      if (root == null) {
         node = new TreeNode(d);
         node.parent = null;
         return root = node;
      }
      curr = root;
      while ((cmp = d.compareTo(curr.data)) != 0) {
         if (cmp < 0) { //prbujemy z lewej
            if (curr.left == null) {
               curr.left  = new TreeNode(d);
               curr.left.parent = curr;
               return curr.left;
            }
            curr = curr.left;
         }
         else { //prbujemy z prawej
            if (curr.right == null)  {
               curr.right = new TreeNode(d);
               curr.right.parent = curr;
               return curr.right;
            }
            curr = curr.right;
         } //koniec else
      } //koniec while
      return curr;  //d jest w drzewie; zwracamy wskanik na wierzchoek
   } //koniec findOrInsert
    
} //koniec klasy BinaryTree
                        