// Program P7.7

import java.io.*;
import java.util.*;
public class ReadRandomAccess {
   static final int StringFixedLength = 20;
   static final int PartNumSize = 6;
   static final int PartRecordSize = 64;
   
   public static void main(String[] args) throws IOException {
      RandomAccessFile fp = new RandomAccessFile("parts.bin", "rw");
      Scanner kb = new Scanner(System.in);
      System.out.printf("\nPodaj numer rekordu: ");
      int n = kb.nextInt();
      while (n != 0) {
         fp.seek(PartRecordSize * (n - 1));
         readPartFromFile(fp).printPart();
         System.out.printf("\nPodaj numer rekordu: ");
         n = kb.nextInt();
      }
   } //koniec main
   
   public static Part readPartFromFile(RandomAccessFile f) throws IOException {
      String pname = "";
      for (int h = 0; h < PartNumSize; h++) pname += f.readChar();
      char[] name = new char[StringFixedLength];
      for (int h = 0; h < StringFixedLength; h++) name[h] = f.readChar();
      String hold = new String(name, 0, StringFixedLength);
      return new Part(pname, hold.trim(), f.readInt(), f.readDouble());
   } //koniec readPartFromFile

} //koniec klasy ReadRandomAccess

class Part {
   String partNum, name;
   int amtInStock;
   double price;
  
   public Part(String pn, String n, int a, double p) {
      partNum = pn;
      name = n;
      amtInStock = a;
      price = p;
  }

   public void printPart() {
      System.out.printf("Numer czci: %s\n", partNum);
      System.out.printf("Nazwa czci: %s\n", name);
      System.out.printf("Liczba dostpnych czci: %d\n", amtInStock);
      System.out.printf("Cena: %3.2f z\n", price);
   }
} //koniec klasy Part

