class Node {
   NodeData data;

   Node next;
   public Node(NodeData nd) {
      data = nd;
      next = null;
   }
} //koniec klasy Node

public class LinkedList {
   Node head = null;

   public boolean empty() {
      return head == null;
   }

   public void addHead(NodeData nd) {
      Node p = new Node(nd);
      p.next = head;
      head = p;
   }

   public void addInPlace(NodeData nd) {
      Node np, curr, prev;
      np = new Node(nd);
      prev = null;
      curr = head;
      while (curr != null && nd.compareTo(curr.data) > 0) { //nowa warto jest wiksza
         prev = curr;
         curr = curr.next;
      }
      np.next = curr;
      if (prev == null) head = np;
      else prev.next = np;
   } //koniec addInPlace

   public void printList() {
      Node curr = head;
      while (curr != null) {
         System.out.printf("%s", curr.data); //wywouje curr.data.toString()
         curr = curr.next;
      }
      System.out.printf("\n");
   } //koniec printList

   public NodeData getHeadData() {
      if (head == null) return null;
      return head.data;
   }
   
   public void deleteHead() {
      if (head != null) head = head.next;
   }   
   
   public void addTail(NodeData nd) {
      Node p = new Node(nd);
      if (head == null) head = p;
      else {
         Node curr = head;
         while (curr.next != null) curr = curr.next;
         curr.next = p;
      }
   } //koniec addTail   
   
   public LinkedList copyList() {
      LinkedList temp = new LinkedList();
      Node curr = this.head;
      while (curr != null) {
         temp.addTail(curr.data);
         curr = curr.next;
      }
      return temp;
   } //koniec copyList   
   
   public void reverseList() {
      Node p1, p2, p3;
      if (head == null || head.next == null) return;
      p1 = head;
      p2 = p1.next;
      p1.next = null;
      while (p2 != null) {
         p3 = p2.next;
         p2.next = p1;
         p1 = p2;
         p2 = p3;
      }
      head = p1;
   } //koniec reverseList   
   
   public boolean equals(LinkedList LL) {
      Node t1 = this.head;
      Node t2 = LL.head;
      while (t1 != null && t2 != null) {
         if (t1.data.compareTo(t2.data) != 0) return false;
         t1 = t1.next;
         t2 = t2.next;
      }
      if (t1 != null || t2 != null) return false; //jeli jedna z list si skoczya
                                                  //ale druga nie
      return true;
   } //koniec equals
   
   public LinkedList merge(LinkedList LL) {
      Node A = this.head;
      Node B = LL.head;
      LinkedList C = new LinkedList();
      while (A != null && B != null) {
         if (A.data.compareTo(B.data) < 0) {
            C.addTail(A.data);
            A = A.next;
         }
         else {
            C.addTail(B.data);
            B = B.next;
         }
      }
      while (A != null) {
         C.addTail(A.data);
         A = A.next;
      }
      while (B != null) {
         C.addTail(B.data);
         B = B.next;
      }
      return C;
   } //koniec merge      
      
   
} //koniec klasy LinkedList
