// Program P10.1

import java.util.*;
import java.io.*;
public class DistinctNumbers {
   final static int MaxDistinctNumbers = 20;
   final static int N = 23;
   final static int Empty = 0;
    
   public static void main(String[] args) throws IOException {
      Scanner in = new Scanner(new FileReader("numbers.in"));
      int[] num = new int[N + 1];
      for (int j = 1; j <= N; j++) num[j] = Empty;
      int distinct = 0;
      while (in.hasNextInt()) {
         int key = in.nextInt();
         int loc = key % N + 1;
         while (num[loc] != Empty && num[loc] != key) loc = loc % N + 1;
         
         if (num[loc] == Empty) { //klucza nie ma w tablicy
            if (distinct == MaxDistinctNumbers) {
               System.out.printf("\nTablica jest pena: pomijam liczb %d.\n", key);
               System.exit(1);
            }
            num[loc] = key;
            distinct++;
         }
      } //koniec while
      System.out.printf("\nW tablicy zapisano %d unikalnych liczb.\n", distinct);
      in.close();
   } //koniec main
            
} //koniec klasy DistinctNumbers
