// Program P3.7

import java.util.*;

public class CountOut {
   public static void main(String[] args) {
      Scanner in = new Scanner(System.in);
      int m, n;
      do {
         System.out.printf("Podaj liczb dzieci i dugoc wyliczanki: ");
         n = in.nextInt();
         m = in.nextInt();
      } while (n < 1 || m < 1);
      Node last = linkCircular(n); // tworzymy cyliczn list dzieci
      Node winner = playGame(last, n-1, m); // eliminujemy n-1 dzieci
      System.out.printf("Zwyciyo dziecko numer: %d\n", winner.num);
   } //koniec main

   public static Node linkCircular(int n) {
   //metoda czym n dzieci tworzc cykliczn list powizan
   //zwraca wskanik do ostatniego dziecka, ktre 
   //wskazuje na pierwsze.
      Node first, np;

      first = np = new Node(1);      //pierwsze dziecko
      for (int h = 2; h <= n; h++) { //czymy z pozostaymi
         np.next = new Node(h);
         np = np.next;
      }
      np.next = first; //ostatnie dziecko ma wskazywa na pierwsze
      return np;
   } //koniec linkCircular

   public static Node playGame(Node last, int x, int m) {
   //metoda eliminuje x dzieci uywajc wyliczanki o dugoci m
   //parametr last wskazuje na ostatnie dziecko, ktre z kolei 
   //wskazuje na pierwsze.
      Node prev = last, curr = last.next; //curr wskazuje na pierwsze dziecko
      //eliminujemy x dzieci
      for (int h = 1; h <= x; h++) {
         //curr wskazuje na piersze dziecko, od ktrego naley
         //rozpocz wyliczanie
         //odliczamy m-1 by dotrze do m-tego dziecka
         for (int c = 1; c < m; c++) {
            prev = curr;
            curr = curr.next;
         }
         //usuwamy m-te dziecko
         prev.next = curr.next;
         curr = prev.next; //zmieniamy curr by wskazywaa na nastpne 
                           //dziecko za wyeliminowanym
      }
      return curr;
   } //koniec playGame
} //koniec klasy CountOut

class Node {
   int num;
   Node next;
   public Node(int n) {
      num = n;
      next = null;
   }
} //koniec klasy Node
