import java.io.*;
//====================================
//Output file class
public class OutFile 
{
 BufferedWriter f;
 PrintWriter p;
 boolean errflag;
 int tabcolumn;
 int width;
//-----------------------------------
 public OutFile(String filename)
 {
 errflag = false;
 tabcolumn = 0;
 width = 0;
 try
  {
  f= new BufferedWriter(new FileWriter(filename));
  }
  catch(IOException e)
   {
   errflag = true;
   }
 p = new PrintWriter(f);
 }
//-----------------------------------
public void tab()
{
p.print("\t");
}
//-----------------------------------
public String space(int n)
{
 StringBuffer sb = new StringBuffer(n);
 //put spaces into string buffer
 for (int i=0; i < n; i++)
  {
  sb.insert(i, ' ');
  }
 return sb.toString();
}
//-----------------------------------
public void setWidth(int n)
{
}
//-----------------------------------
public void tab(int tb)
{
if (tb > tabcolumn)
 {
 print(space(tb - tabcolumn));
 }                           
else
  println("");
}
//-----------------------------------
public void println(String s)
{
 p.println(s);
 tabcolumn = 0;
}
//-----------------------------------
public void println(int i)
{
 p.println(i);
 tabcolumn = 0;
}
//-----------------------------------
public void println(double d)
{
 tabcolumn = 0;
 p.println(d);
}
//-----------------------------------
public void print(String s)
{
 p.print(s);
 tabcolumn += s.length();
}
//-----------------------------------
public void print(int i)
{
String s=new Integer(i).toString();
if (s.length() < width)
  print(space(width-s.length()) );
print(s);
}
//-----------------------------------
public void print(float f)
{
 String s=new Float(f).toString();
 print(s);
}
//-----------------------------------
public void print(double d)
{
 String s=new Double(d).toString();
 print(s);
}
//-----------------------------------
public void close()
{
p.close();
}
//-----------------------------------
public void finalize()
{
close();
}
//-----------------------------------
}
