//*** Klasa View

package janb.view;

import java.applet.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.awt.font.*;
import java.util.*;

import java.lang.reflect.*;
import java.net.*;
import java.io.*;

public    
class View
    extends Applet
    implements Names, Runnable {    

    private static boolean initViewDone   = false;    
    private static boolean viewClassUsed  = false;
    private static boolean separateThread = true;
    public View()
    {
        if(viewClassUsed) {
            error("Only one View allowed!");
            System.exit(0);
        } else
            viewClassUsed = true;
    }
        
    private static boolean firstPaint  = true, 
                           viewVisible = false,
                           viewReady   = false;
    private static Toolkit kit = 
        Toolkit.getDefaultToolkit();
    private static int w, h;    
    private static int pX, pY;
    private static Dimension d;
    private static View view;    
    private static ViewPanel panel;
    protected static ViewPanel viewPanel;
    protected static Graphics2D pDC, pDC1, pDC2;
    private static TextField textField;
    private static int dH = 20;        
    private static int size = 30, fill = Thin;
    private static Font resultFont = 
        new Font("Serif", Font.BOLD | Font.ITALIC, 30);
    private static Stroke thinStroke = new BasicStroke(1);
    private static Random rand = new Random();   
    private static Vector dataVector = new Vector();
    private static Object dataLock = new Object();
    private static boolean dataReady = false;
    private static int dataPos = 0;
    private static ButtonWatcher buttonWatcher;
    private static MediaTracker tracker;
    private static Image buffer;
    private static boolean isBuffered = false,
                           isDebugged = false;
    private static Point dbgLoc;
    private static Dimension dbgSize;
         
    public void init()    
    {
        view = this;
        
        setLayout(new BorderLayout());

        d = getSize();
        w = d.width;
        h = d.height - dH;
        setSize(w, d.height); 
        
        panel = new ViewPanel();   
        viewPanel = panel;
        add(panel, BorderLayout.CENTER);
        panel.setLayout(null);        
                
        MouseWatcher mouseWatcher = new MouseWatcher(panel);
        panel.addMouseListener(mouseWatcher);
        panel.addMouseMotionListener(mouseWatcher);         
        
        KeyWatcher keyWatcher = new KeyWatcher(panel);
        panel.addKeyListener(keyWatcher);
        panel.requestFocus();        
        
        textField = new DataField();
        add(textField, BorderLayout.SOUTH);               
                      
        textField.addActionListener(
            new ActionListener() {
                public void
                actionPerformed(ActionEvent evt)
                {
                    String str = evt.getActionCommand();
                    if(str.trim().equals("")) {
                        showMsg("Empty data line!");
                        beep();
                        textField.setText("");
                        requestFocus();
                        panel.requestFocus();
                        return;
                    }

                    Vector vec = new Vector();
                    while(!(str = str.trim()).equals("")) {
                        str += ' ';
                        int i = str.indexOf(' ');
                        vec.add(str.substring(0, i));
                        str = str.substring(i);
                    }
                    
                    int size = vec.size();
                    String[] data = new String [size];
                    for(int i = 0; i < size ; i++) {
                        data[i] = (String)vec.elementAt(i);
                    }
                    
                    synchronized(dataLock) {
                        if(separateThread) {
                            dataVector.add(data);
                            dataReady = true;
                            dataLock.notify();
                        } else {
                            dataEntered(data);
                            return;
                        }
                    }
                }
            }
        );
        
        new Reader();
        
        buttonWatcher = new ButtonWatcher();
               
        pDC = pDC2 = (Graphics2D)panel.getGraphics();   
        pDC1 = (Graphics2D)panel.getGraphics();   
        Font font = pDC.getFont();
        pDC.setFont(font);
        pDC1.setFont(font);

        Point loc = getLocation();
        dbgLoc  = new Point(loc.x + w + 10, loc.y);
        dbgSize = new Dimension(200, h + dH);
        
        requestFocus();
        panel.requestFocus();
    }
    
    class Reader 
        extends Thread {
        
        public Reader()
        {
            this.start();
        }
        
        public void run()
        {
            while(true) {
                synchronized(dataLock) {
                    while(!dataReady) {
                        try {
                            dataLock.wait();
                        }
                        catch(InterruptedException e) {
                        }
                    }
                    String[] data = 
                        (String [])dataVector.
                                   elementAt(dataPos);
                    dataVector.set(dataPos++, null);
                    panel.requestFocus();
                    if(data.length > 1)
                        dataEntered(data);
                    else if(data[0].length() > 1)
                        dataEntered(data[0]);
                    else
                        dataEntered(data[0].charAt(0));
                    dataReady = false;
                }
            }
        }
    }
    
    // ============================================= Panel
                           
    class ViewPanel
        extends Panel {
                
        class RunView
            extends Thread {
            
            public RunView()
            {
                this.start();
            }
            
            public void run()
            {
                runView();
            }
        }
               
        public void paint(Graphics pDC)
        {
            if(firstPaint) {
                firstPaint  = false;
                viewVisible = true;
                viewReady   = true;  
                if(!initViewDone) {
                    view.requestFocus();
                    textField.requestFocus();
                    initView(); 
                    new RunView();
                }
                if(!isValid()) {
                   viewReady = false;
                   validate();
                   viewReady = true;
                }
                if(!initViewDone)
                    startView();
                initViewDone = true;
            }
            Dimension d2 = view.getSize();             
            if(!d2.equals(d)) {      
                view.setSize(w, h + dH);
            }
            drawView((Graphics2D)pDC);            
        }                
        
        public Dimension getPreferredSize()
        {
            return new Dimension(w, h);
        }
        
        public Graphics2D getGraphics2D()
        {
            return (Graphics2D)this.getGraphics();
        }
        
        public void addButton(Button button)
        {
            super.add(button);
        }
        
        public void addButton(Button button, int pos)
        {
            super.add(button, pos);
        }               
        
        public void addLabel(Label label)
        {
            super.add(label);
        }
        
        public void addLabel(Label label, int pos)
        {
            super.add(label, pos);
        }       
    }
    
    class DataField 
        extends TextField {
        
        public Dimension getPreferredSize()
        {
            return new Dimension(100, dH);
        }
    }

    public void initView()
    {
    }
    
    public void startView()
    {
    }
    
    public void stopView()
    {
    }
    
    public void drawView(Graphics2D pDC)
    {
        drawView((Graphics)pDC);
    }
    
    public void drawView(Graphics pDC)
    {
        drawView();
    }
    
    public void drawView()
    {
    }
    
    public void exitView()
    {
        System.exit(0);
    }        
    
    public void destroyView()
    {
    }
    
    public void start()
    {
        if(firstPaint)
            return;
        view.startView();
    }
    
    public void stop()
    {
        view.stopView();
    }
    
    public void destroy()
    {
    }
    
    // ============================================= Metrics

    public static TextLayout getLayout(String string, 
                                       Font font, 
                                       Graphics2D gDC)
    {
        FontRenderContext frc = gDC.getFontRenderContext();
        return new TextLayout(string, font, frc);
    }    
        
    public static TextLayout getCurrentLayout(String string,
                                              Font font)
    {
        return getLayout(string, font, pDC);
    }    
    
    public static Metrics getMetrics(String string,
                                     Font font,
                                     Graphics2D gDC)
    {
        TextLayout layout = getLayout(string, font, gDC);
        return new Metrics(layout);
    }
    
    public static Metrics getMetrics(String string,
                                     Font font)
    {
        TextLayout layout = getLayout(string, font, pDC);
        return new Metrics(layout);
    }
    
    public static Metrics getMetrics(String string)
    {
        TextLayout layout = 
            getLayout(string, getCurrentFont(), pDC);
        return new Metrics(layout);
    }    
    
    public static Metrics getCurrentMetrics(String string,
                                            Font font)
    {
        TextLayout layout = getLayout(string, font, pDC);
        return new Metrics(layout);
    }
    
    public Metrics getMetrics(Figure figure)
    {
        if(figure instanceof String$) {
            Font oldFont = pDC.getFont(),
                 font = figure.getFont();
            String$ string$ = (String$)figure;
            String string = string$.getString();
            Metrics metrics = 
                string$.getMetrics(string, font, pDC);
            pDC.setFont(oldFont);
            return metrics;
        } else
            return null;
    }
    
    public static int getWidth(Metrics metrics)
    {
        return metrics.getWidth();
    }
    public static int getHeight(Metrics metrics)
    {
        return metrics.getHeight();
    }
        
    public static int getAscent(Metrics metrics)
    {
        return metrics.getAscent();
    }
    
    public static int getDescent(Metrics metrics)
    {
        return metrics.getDescent();
    }    
              
    public static Rectangle2D getBounds(String string, 
                                        Font font)
    {
        FontRenderContext frc = 
            pDC.getFontRenderContext();
        TextLayout layout = new TextLayout(string, font, frc);
        return new TextLayout(string, font, frc).getBounds();
    }
                    
    // ============================================== Graphics
    
    public void clearView(int x, int y, int w, int h)
    {
        pDC.clearRect(x-1, y-1, w+2, h+2);    
    }    
    
    public void clearView(int x, int y, int s)
    {
        clearView(x, y, s, s);
    }
    
    public void clearView()
    {
        clearView(0, 0, w, h);
    }
              
    public void showMsg(String msg)
    {
        showStatus(msg);
    }
    
    public void showMsg(long msg)
    {
        showMsg("" + msg);
    }
    
    public void repaint()
    {
        redraw();
    }
    
    public void redraw()
    {
        clearView();
        drawView(pDC);
    }
    
    // ============================================= Figures
           
    public Figure getPixel(int x, int y, Graphics gDC)
    {
        return new Pixel(x, y, gDC);
    }
    
    public Figure getPixel(int x, int y)
    {
        return new Pixel(x, y, pDC);
    }    
    
    public Figure getString(int x, int y, 
                            String string, Graphics gDC)
    {
         return new String$(x, y, string, gDC);   
    }
       
    public Figure getString(int x, int y, String string)
    {
        return new String$(x, y, string, pDC);
    }
       
    public Figure getLine(int xA, int yA, 
                          int xZ, int yZ, Graphics gDC)
    {
        return new Line(xA, yA, xZ, yZ, gDC);
    }
    
    public Figure getLine(int xA, int yA, 
                          int xZ, int yZ)
    {
        return new Line(xA, yA, xZ, yZ, pDC);
    }    

    public Figure getImage(int x, int y, 
                           int w, int h, Image image)
    {
        return new Image$(x, y, w, h, image, this);            
    }
    
    public Figure getImage(int x, int y, Image image)
    {
        return new Image$(x, y, image, this);            
    }    

    public Figure getEllipse(int x, int y, 
                             int w, int h, Graphics gDC
                  )
    {
        return new Ellipse(x, y, w, h, gDC);
    }        
    
    public Figure getEllipse(int x, int y, int w, int h)
    {
        return getEllipse(x, y, w, h, pDC);
    }
    
    public Figure getCircle(int x, int y, 
                            int d, Graphics gDC)
    {
        return new Ellipse(x, y, d, d, gDC);
    }
        
    public Figure getCircle(int x, int y, int d)
    {
        return getCircle(x, y, d, pDC);
    }
                
    public Figure getRectangle(int x, int y, 
                               int w, int h, Graphics gDC)
    {
        return new Rectangle(x, y, w, h, gDC);
    }

    public Figure getRectangle(int x, int y, int w, int h)
    {
        return new Rectangle(x, y, w, h, null);
    }
    
    public Figure getSquare(int x, int y, int d, Graphics gDC)
    {
        return getRectangle(x, y, d, d, gDC);
    }
    
    public Figure getSquare(int x, int y, int d)
    {
        return getSquare(x, y, d, pDC);
    }
    
    public Figure getDiamond(int x, int y, 
                             int w, int h, Graphics gDC)
    {
        return new Diamond(x, y, w, h, gDC);
    }
    
    public Figure getDiamond(int x, int y, int w, int h)
    {
        return new Diamond(x, y, w, h, pDC);
    }    
    
    public Figure getDiamond(int x, int y, 
                             int d, Graphics gDC)
    {   
        return getDiamond(x, y, d, d, gDC);
    }
    
    public Figure getDiamond(int x, int y, int d)
    {   
        return getDiamond(x, y, d, d, pDC);
    }    
    
    public Figures getFigures()
    {
        return new Figures();
    }

    public void drawFigures(Figures figures)
    {
        figures.drawFigures(pDC);
    }
    
    public static void drawFigure(Figure figure)
    {
        figure.draw(pDC);
    }
    
    public int length(Figures figures)
    {
       return figures.size();
    }
    
    public void addFigure(Figures figures, Figure figure)
    {
        figures.add(figure);
    }
    
    public void setFigure(Figures figures, Figure figure, int pos)
    {
        figures.set(pos, figure);
    }    
    
    public Figure getFigure(Figures figures, int pos)
    {
        return figures.getFigure(pos);
    }
    
    public void setXY(Figure figure, int x, int y)
    {
        figure.setXY(x, y);        
    }

    public void setSize(Figure figure, int w, int h)
    {
        figure.setSize(w, h);
    }
        
    public void setStroke(Figure figure, Stroke stroke)
    {
        figure.setStroke(stroke);
    }

    public void setPaint(Figure figure, Paint paint)
    {
        figure.setPaint(paint);
    }
    
    public void setColor(Figure figure, Color color)
    {
        figure.setPaint(color);
    }
    
    public void setFont(Figure figure, Font font)
    {
        figure.setFont(font);
    }

    public void setFill(Figure figure, int fill)
    {
        figure.setFill(fill);
    }
    
    public int getX(Figure figure)
    {
        return figure.getX();
    }
    
    public int getY(Figure figure)
    {
        return figure.getY();
    }
    
    public int getWidth(Figure figure)
    {
        return figure.getWidth();
    }    
    
    public int getHeight(Figure figure)
    {
        return figure.getHeight();
    }

    public Paint getPaint(Figure figure)
    {
        return figure.getPaint();
    }
    
    public Paint getColor(Figure figure)
    {
        Paint paint = figure.getPaint();
        if(paint instanceof Color)
            return paint;
        else
            return null;
    }
    
    public Stroke getStroke(Figure figure)
    {
        return figure.getStroke();
    }
    
    public Font getFont(Figure figure)
    {
        return figure.getFont();
    }
    
    public int getFill(Figure figure)
    {
        return figure.getFill();
    }

    // ============================================= (Figures)
    
    public Color getColor(int r, int g, int b)
    {
        return new Color(r, g, b);
    }
    
    public Color getColor(int argb)
    {
        return new Color(argb);
    }
           
    public Color getColor()
    {    
        Color color;
        int max3, min3, r, g, b;
        do {
            int rnd = rand.nextInt();
            color = new Color(rnd);
            r = color.getRed();
            g = color.getGreen();
            b = color.getBlue();
            max3 = max(max(r, g), b);
            min3 = min(min(r, g), b);
        } while(max3 - min3 < 20);
        return color;
    } 
                            
    public void setSizes(int size)
    {
        this.size = size;
    }
    
    public void setStroke(int width, double ratio, 
                          int cap, int butt)
    {
        float line = (float)(20 * ratio),
              gap  = (float)(20 * (1.0 - ratio));
        pDC.setStroke(
            new BasicStroke(
                width,
                cap,
                butt,
                100,
                new float[] { line, gap },
                0
            )
        );
    }    
    
    public void setStroke(int width, double ratio)
    {
        setStroke(
            width, ratio, 
            BasicStroke.CAP_BUTT,   // zakoczenie cite
            BasicStroke.JOIN_MITER  // poczenie zaostrzone
        );
    }
    
    public void setStroke(int width)
    {
        setStroke(width, 1.0f);
    }
    
    public Stroke getStroke()
    {
        return pDC.getStroke();
    } 
    
    public Stroke getStroke(int width)
    {
        return new BasicStroke(width);
    }
    
    public void setStroke(float width, int cap, int join, 
                            float miter, float[] dash, float phase)
    {
        pDC.setStroke(
            new BasicStroke(
                width, cap, join, miter, dash, phase
            )
        );
    }
    
    public Color setColor(Color color)
    {
        Color oldColor = pDC.getColor();
        pDC.setColor(color);
        return oldColor;
    }
    
    public Paint getGradient(Color from, Color to, 
                             int x, int y, int w, int h)
    {
        return new GradientPaint(x, y, from, w, h, to);         
    }
        
    public Paint getGradient(Color from, Color to)
    {
        return new GradientPaint(0, 0, from, w, h, to);
    }
    
    public Paint getGradient()
    {
        return getGradient(getColor(), getColor());
    }
    
    public Paint getGradient(int x, int y, int w, int h)
    {
         return getGradient(
                    getColor(), getColor(), x, y, w, h
                );
    }

    public Paint getTexture(Image image)
    {
        BufferedImage img = 
            new BufferedImage(
                8, 8,                         // rozmiary
                BufferedImage.TYPE_INT_RGB    // model
            );
        Graphics2D mDC = img.createGraphics();
        mDC.drawImage(image, 0, 0, this);
        Rectangle2D.Double square = 
            new Rectangle2D.Double(0, 0, 32, 32);
        return new TexturePaint(img, square); 
    }
    
    public static Stroke getCurrentStroke()
    {
        return pDC.getStroke();
    }
    
    
    public static Paint getCurrentPaint()
    {
        return pDC.getPaint();
    }

    public void setPaint(Paint paint)
    {
        pDC.setPaint(paint);
    }

    public void setPaint(Color from, Color to)
    {
        setPaint(
            new GradientPaint(0, 0, from, w, h, to)
        );
    }
    
    public void setPaint(Image img)
    {
        setPaint(getTexture(img));
    }
               
    public int getRed(Color color)
    {
        return color.getRed();
    }
    
    public int getGreen(Color color)
    {
        return color.getGreen();
    }
    public int getBlue(Color color)
    {
        return color.getBlue();
    }    
    
    // ============================================= Strings
    
    public static void drawString(int x, int y, 
                                  String string)
    {
        Figure figure = new String$(x, y, string, pDC);
        drawFigure(figure);    
    }
    
    public static void drawString(int x, int y, 
                                  String string,
                                  Font font)
    {
        Font oldFont = pDC.getFont();
        pDC.setFont(font);
        drawString(x, y, string);
        pDC.setFont(oldFont);
    }                                  

    public boolean isLetter(char data)
    {
        return data >= 'a' && data <= 'z' ||
               data >= 'A' && data <= 'Z';
    }
    
    public boolean isAlpha(String data)
    {
        int length = data.length();
        boolean result = true;
        for(int i = 0; i < length; i++)
            result &= isLetter(data.charAt(i));
        return result;
    }   
    
    public boolean eq(String str1, String str2)
    {
        return str1.equals(str2);
    }
    
    public boolean ne(String str1, String str2)
    {
        return !eq(str1, str2);
    }
    
    public boolean gt(String str1, String str2)
    {
        return str1.compareTo(str2) > 0;
    }
    
    public boolean lt(String str1, String str2)
    {
        return str1.compareTo(str2) < 0;
    }
    
    public boolean ge(String str1, String str2)
    {
        return !lt(str1, str2);
    }
    
    public boolean le(String str1, String str2)
    {
        return !gt(str1, str2);
    }
    
    public String trim(String str)
    {
        return str.trim();
    }
    
    public String toLower(String str)
    {
        return str.toLowerCase();
    }

    public String toUpper(String str)
    {
        return str.toUpperCase();
    }
    
    public char toLower(char chr)
    {
        if(chr >= 'A' && chr <= 'Z')
            return (char)(chr - 'A' + 'a');
        return chr;
    }
    
    public char toUpper(char chr)
    {
        if(chr >= 'a' && chr <= 'z')
            return (char)(chr - 'a' + 'A');
        return chr;
    }
    
    public char charAt(String string, int pos)
    {
        return string.charAt(pos);
    }
    
    public int indexOf(String string, char chr)
    {
        return string.indexOf(chr);
    }
    
    public int indexOf(String string, String substr)
    {
        return string.indexOf(substr);
    }
    
    public String substring(String string, int from, int to)
    {
        return string.substring(from, to);
    }
    
    public String substring(String string, int from)
    {
        return string.substring(from);
    }
    
    // ============================================= Time
    
    
    private Calendar greg =
        GregorianCalendar.getInstance();
        
    public int getTime()
    {
        greg.setTime(new Date());
        return greg.get(Calendar.HOUR)   << 16 |    
               greg.get(Calendar.MINUTE) <<  8 |    
               greg.get(Calendar.SECOND);    
    }
        
    public int getHour(int time)
    {
        return (time >> 16) & 0xff;
    }    
    
    public int getMinute(int time)
    {
        return (time >> 8) & 0xff;
    } 
       
    public int getSecond(int time)
    {
        return time & 0xff;
    }    
    
    public long getMillis()
    {
        return System.currentTimeMillis();
    }
        
    // ============================================= Data
    
    public void setData(String string)
    {
        textField.setText(string);
    }
    
    public String getData()
    {
        return textField.getText();
    }
    
    public void showResult(String result)
    {
        Font oldFont = pDC.getFont();
        pDC.setFont(resultFont);
        clearView();
        pDC.drawString(result, 10, h/2);
        pDC.setFont(oldFont);
    }
    
    public void showResult(String result, int size)
    {
        Font font = new Font("Serif", Font.BOLD, size),
             oldFont = pDC.getFont();
        pDC.setFont(font);
        clearView();
        pDC.drawString(result, 10, h/2);
        pDC.setFont(oldFont);
    }
    
    public void showResult(double result)
    {
        showResult("" + result);
    }
    
    public void showResult(long result)
    {
        showResult("" + result);
    }
                
    public void beep()
    {
        Toolkit.getDefaultToolkit().beep();
    }    
    
    public int length(Object[] vec)
    {
        return vec.length;
    }
    
    public int length(int[] vec)
    {
        return vec.length;
    }
    
    public int length(double[] vec)
    {
        return vec.length;
    }   
    
    public int length(String string)
    {
        return string.length();
    }
    
    public void dataEntered(String[] data)
    {
        Toolkit.getDefaultToolkit().beep();
    }
    
    private String[] vector = { "" };
    
    public void dataEntered(String data)
    {
        vector[0] = data;
        dataEntered(vector);
    }
    
    public void dataEntered(char data)
    {
        String string = "" + data;
        dataEntered(string);    
    }        
       
    public int[] getValues(String[] data)
    {
        int[] values = new int [data.length];
        for(int i = 0; i < data.length ; i++) {
            try {
                values[i] = Integer.parseInt(data[i]);
            }
            catch(NumberFormatException e) {
                return null;
            }
        }
        return values;        
    }
    
    public String getString(String[] strings)
    {
        String string = "";
        for(int i = 0; i < strings.length; i ++)
            string += strings[i] + ' ';
        return string;
    }
    
    // ============================================= Math


    public int abs(int arg)
    {
        return Math.abs(arg);
    }
    
    public double abs(double arg)
    {
        return Math.abs(arg);
    }
    
    public int min(int arg1, int arg2)
    {
        return Math.min(arg1, arg2);
    }
    
    public int max(int arg1, int arg2)
    {
        return Math.max(arg1, arg2);
    }    
    
    public double min(double arg1, double arg2)
    {
        return Math.min(arg1, arg2);
    }
    
    public double max(double arg1, double arg2)
    {
        return Math.max(arg1, arg2);
    }
    
    public boolean isOdd(int arg)
    {
        return arg % 2 == 1;
    }
    
    public boolean isEven(int arg)
    {
        return arg % 2 == 0;
    }    
    
    public int getRandom(int min, int max)
    {
        int span = max - min + 1;
        return Math.abs(rand.nextInt()) % span + min;
    }
    
    public int getRandom(int range)
    {
        return getRandom(0, range-1);
    }
    
    public int getRandom()
    {
        return rand.nextInt();
    }
    
    public double sin(double arg)
    {
        return Math.sin(arg);
    }
    
    public double sin(int arg)
    {
        return sin(Pi * arg / 180);
    }

    public double cos(double arg)
    {
        return Math.cos(arg);
    }
    
    public double cos(int arg)
    {
        return cos(Pi * arg / 180);    
    }
        
    public double tan(double arg)
    {
        return Math.tan(arg);
    }    
    
    public double tan(int arg)
    {
        return tan(Pi * arg / 180);    
    }    
    
    public double sqrt(double arg)
    {
        return Math.sqrt(arg);
    }    
    
    public double pow(double b, double e)
    {
        return Math.pow(b, e);
    }
    
    public double log(double arg)
    {
        return Math.log(arg);
    }
    
    // ============================================= Fonts
    
    public static Font getCurrentFont()
    {
        return pDC.getFont();
    }
    
    public void setFont(Font font)
    {
        pDC.setFont(font);
    }   
    
    public Font getFont(String face, int style, int size)
    {
        return new Font(face, style, size);
    }
    
    // ============================================= Cursors
    
    public void setCursor(Cursor cursor)
    {
        panel.setCursor(cursor);
    }   
    
    public Cursor getCursor(String string, Point pHot)
    {
        URL docBase = getDocumentBase();
        Image img = getImage(string);
        return kit.createCustomCursor(img, pHot, string);
    }
    
    public Cursor getCursor(
                      String string, int xHot, int yHot
                  )
    {
        return getCursor(string, new Point(xHot, yHot));
    }
    
    
    // ============================================= Graphics        
    
    public void setFill(int fill)
    {
        this.fill = fill;
    }
          
    public void drawString(String string, int x, int y)
    {
        pDC.drawString(string, x, y);
    }   
    
    public void drawPixel(int x, int y)
    {
        drawLine(x, y, x, y);
    }
    
    public void drawPixel(Point p)
    {
        drawLine(p.x, p.y, p.x, p.y);
    }
    
    public void drawLine(int xA, int yA, int xZ, int yZ)
    {
        pDC.drawLine(xA, yA, xZ, yZ);
    }
    
    public void drawLine(Point pA, Point pZ)
    {
        pDC.drawLine(pA.x, pA.y, pZ.x, pZ.y);
    }    
    
    public void moveTo(Point p)
    {
        pX = p.x;
        pY = p.y;
    }
    
    public void moveTo(int x, int y)
    {
        pX = x;
        pY = y;
    }
    
    public void lineTo(int x, int y)
    {
        pDC.drawLine(pX, pY, pX = x, pY = y);
    }       
    
    public void lineTo(Point p)
    {
        lineTo(p.x, p.y);
    }
    
    public void drawEllipse(int x, int y, 
                            int w, int h, int fill)
    {
        Figure figure = getEllipse(x, y, w, h, pDC);
        figure.setFill(fill);
        figure.draw(pDC);
    }
    
    public void drawRectangle(int x, int y, 
                              int w, int h, int fill)
    {
        Figure figure = getRectangle(x, y, w, h, pDC);
        figure.setFill(fill);
        figure.draw(pDC);
    }    
    
    public void drawDiamond(int x, int y, 
                            int w, int h, int fill)
    {
        Figure figure = getDiamond(x, y, w, h, pDC);
        figure.setFill(fill);
        figure.draw(pDC);
    }    
                  
    public void drawEllipse(int x, int y, 
                            int w, int h)
    {
        Figure ellipse = getEllipse(x, y, w, h, pDC);
        ellipse.setFill(fill);
        ellipse.draw(pDC);
    }
    
    public void drawCircle(int x, int y, int d)
    {
        drawEllipse(x, y, d, d);
    }
    
    public void drawRectangle(int x, int y, 
                              int w, int h)
    {
        Figure rectangle = getRectangle(x, y, w, h, pDC);
        rectangle.setFill(fill);
        rectangle.draw(pDC);
    }
           
    public void drawSquare(int x, int y, int d)
    {
        drawRectangle(x, y, d, d);
    }       
        
    // ============================================= Cheats
    
    public static void warning(String warning)
    {
        System.out.println(
            "\n\nWarning: " + warning + "\n\n"
        );
    }
    
    public static void error(String error)
    {
        System.out.println(
            "\n\nError: " + error + "\n\n"
        );
    }    
    
    public void requestFocus()
    {
        super.requestFocus();
        panel.requestFocus();
    }
    
    public Component add(Component component)
    {
        panel.add(component); 
        return component;
    }           
    
    public Component add(Component component, String pos)
    {
        if(viewReady)
            panel.add(component, pos); 
        else
            super.add(component, pos);
        return component;
    }               
          
    public Component add(String pos, Component component)
    {
        if(viewReady)
            panel.add(pos, component); 
        else
            super.add(pos, component);
        return component;
    }               
       
    public void addMouseListener(MouseListener listener)
    {
        panel.addMouseListener(listener);
    }
    
    public void addMouseMotionListener(
                    MouseMotionListener listener
                )
    {
        panel.addMouseMotionListener(listener);
    }
    
    public void addKeyListener(KeyListener listener)
    {
        panel.addKeyListener(listener);
    }       
    
    public Graphics getGraphics()
    {    
        if(panel == null) {
            error(
                "You used illegal " +
                "\"public void init()\" method!"
            );
            return null;
        }
        return panel.getGraphics();
    }
   
    public void setBackground(Color color)
    {
        panel.setBackground(color);
        super.setBackground(color);
    }
    
    public void setLayout(LayoutManager manager)
    {
        super.setLayout(manager);
        if(viewReady)
            panel.setLayout(manager);
    }
       
    public Dimension getSize()
    {
        if(!viewReady)
            return super.getSize();
        else
            return new Dimension(w, h);
    }                          
    
    public int getWidth()
    {
       return w;
    }
    
    public int getHeight()
    {
        return h;
    }
    
    // ============================================= Images
    
    public int getWidth(Image img)
    {
        return img.getWidth(this);
    }
    
    public int getHeight(Image img)
    {
        return img.getHeight(this);
    }    
    
    public Image[] getImages(String[] names)
    {
        Image[] images = new Image [names.length];
        tracker = new MediaTracker(this);
        URL dataBase = getDocumentBase();
        for(int i = 0; i < names.length ; i++) {
            images[i] = getImage(dataBase, names[i]);
            tracker.addImage(images[i], 0);
        }
        try {
            tracker.waitForID(0);
        }
        catch(InterruptedException e) {
        }
        return images;
    }
    
    public Image getImage(String name)
    {
        return getImages(new String [] { name })[0];
    }
       
    public void drawImage(Image img, int x, int y)
    {
        pDC.drawImage(img, x, y, this);
    }
    
    public void drawImage(Image img, int x, int y, 
                          int w, int h)
    {
        pDC.drawImage(img, x, y, w, h, this);
    }    
    
    // ============================================= Mouse
    
    public void mousePressed(int x, int y, int flags) 
    {
        mousePressed(x, y);
    }        
        
    public void mouseReleased(int x, int y, int flags) 
    {
        mouseReleased(x, y);
    }
    
    public void mouseClicked(int x, int y, int flags) 
    {
        mouseClicked(x, y);
    }    
       
    public void mouseMoved(int x, int y, int flags)
    {
        mouseMoved(x, y);
    }

    public void mouseDragged(int x, int y, int flags)
    {
        mouseDragged(x, y);
    }
    
    public void mouseEntered(int x, int y, int flags)
    {
        mouseEntered(x, y);
    }
    
    public void mouseExited(int x, int y, int flags)
    {
        mouseExited(x, y);
    }
    
    public void mousePressed(int x, int y)
    {
    }
    
    public void mouseReleased(int x, int y)
    {
    }
    
    public void mouseClicked(int x, int y)
    {
    }
    
    public void mouseMoved(int x, int y)
    {
    }
    
    public void mouseDragged(int x, int y)
    {
    }
    
    public void mouseEntered(int x, int y)
    {
    }
    
    public void mouseExited(int x, int y)
    {
    }
       
    class MouseWatcher 
        extends MouseAdapter
        implements MouseMotionListener {
        
        ViewPanel panel;
        
        public MouseWatcher(ViewPanel panel)
        {
            this.panel = panel;
        }
        
        public void mousePressed(MouseEvent evt) 
        {
            requestFocus();
            panel.requestFocus();
        
            int flags = evt.getModifiers() & 0xf;
            view.mousePressed(evt.getX(), evt.getY(), flags);
        }        
        
        public void mouseReleased(MouseEvent evt) 
        {
            int flags = evt.getModifiers() & 0xf;
            if(evt.getClickCount() == 2)
                flags |= 0x10;                
            view.mouseReleased(evt.getX(), evt.getY(), flags);
        }                
        
        public void mouseClicked(MouseEvent evt) 
        {
            int flags = evt.getModifiers() & 0xf;
            if(evt.getClickCount() == 2)
                flags |= 0x10;                
            view.mouseClicked(evt.getX(), evt.getY(), flags);
        }                        
        
        public void mouseMoved(MouseEvent evt) 
        {
            int flags = evt.getModifiers() & 0xf;        
            view.mouseMoved(evt.getX(), evt.getY(), flags);
        }

        public void mouseDragged(MouseEvent evt) 
        {
            int flags = evt.getModifiers() & 0xf;        
            view.mouseDragged(evt.getX(), evt.getY(), flags);        
        }        
        
        public void mouseEntered(MouseEvent evt) 
        {
            int flags = evt.getModifiers() & 0xf;        
            view.mouseEntered(evt.getX(), evt.getY());
        }

        public void mouseExited(MouseEvent evt) 
        {
            int flags = evt.getModifiers() & 0xf;        
            view.mouseExited(evt.getX(), evt.getY());        
        }                
    }
    
    // ============================================= Keyboard
      
    public boolean isShift(int flags)
    {
        return (flags & InputEvent.SHIFT_MASK) != 0;
    }
    
    public boolean isCtrl(int flags)
    {
        return (flags & InputEvent.CTRL_MASK) != 0;
    }

    public boolean isAlt(int flags)
    {
        return (flags & InputEvent.ALT_MASK) != 0;
    }

    public boolean isMeta(int flags)
    {
        return (flags & InputEvent.META_MASK) != 0;
    }
    
    public boolean isClick2(int flags)
    {
        return (flags & 1 << 4) != 0;
    }    
    
    public boolean isUnicode(int flags)
    {
        return (flags & 0x80000000) != 0;
    }

    public void keyPressed(int key, int flags) 
    {
        keyPressed(key);
    }        
    
    public void keyReleased(int key, int flags) 
    {
        keyReleased(key);    
    }
    
    public void keyTyped(char key, int flags) 
    {
        keyTyped(key);    
    }
    
    public void keyPressed(int key)
    {
    }
    
    public void keyReleased(int key)
    {
    }
    
    public void keyTyped(char key)
    {
    }
            
    class KeyWatcher 
        extends KeyAdapter {
        
        ViewPanel panel;
        
        public KeyWatcher(ViewPanel panel)
        {
            this.panel = panel;
        }
        
        public void keyPressed(KeyEvent evt) 
        {    
            int flags = evt.getModifiers() & 0xf;
            boolean unicode = 
                evt.getKeyChar() != KeyEvent.CHAR_UNDEFINED;
            if(unicode)
                flags |= 0x80000000;   // jb Unicode flag
            view.keyPressed(evt.getKeyCode(), flags);
        }        
        
        public void keyReleased(KeyEvent evt) 
        {
            int flags = evt.getModifiers() & 0xf;
            view.keyReleased(evt.getKeyCode(), flags);
        }
        
        public void keyTyped(KeyEvent evt)
        {
            int flags = evt.getModifiers() & 0xf;        
            view.keyTyped(evt.getKeyChar(), flags);
        }
    }    
    
    // ============================================= Threads
    
    public void exitBrowser()
    {
        System.exit(0);
    }
    public boolean setSeparate(boolean separate)
    {
        boolean oldSeparate = separateThread;
        separateThread = separate;
        return oldSeparate;
    }
    
    public void runView()
    {
    }
          
    public void run()
    {
    }
    
    public Thread startRun()
    {
        Thread thread = new Thread(this);
        thread.start();
        return thread;
    }
    
    public Thread startRun(Runner runner)
    {
        return runner;
    }
           
    public Object getLock()
    {
        return new Object();
    }
        
    public static void sleep(int time)
    {
        try {
            Thread.sleep(time);
        }
        catch(InterruptedException e) {
        }
    }
    
    public void interrupt(Thread thread)
    {
        thread.interrupt();
    }
    
    public void join(Thread thread)
        throws InterruptedException
    {    
        thread.join();
    }
    
    public boolean isInterrupted(Thread thread)
    { 
        return thread.isInterrupted();
    }    
    
    public boolean isInterrupted()
    {
        return isInterrupted(Thread.currentThread());
    }
     
    // ============================================= Audio

    public AudioClip getAudio(String name)
    {
        URL where = getDocumentBase();
        return getAudioClip(where, name);
    }
    
    public void playAudio(AudioClip clip)
    {
        clip.play();
    }
    
    public void loopAudio(AudioClip clip)
    {
        clip.loop();
    }    
    
    public void stopAudio(AudioClip clip)
    {
        clip.stop();
    }
       
    // ============================================= Layouts
    
    public void setNullLayout()
    {
        panel.setLayout(null);
    }
    
    public void setFlowLayout()
    {
        panel.setLayout(new FlowLayout());    
    }
    
    public void setBorderLayout()
    {
        panel.setLayout(new BorderLayout());    
    }

    public void setGridLayout(int row, int col)
    {
        panel.setLayout(new BorderLayout(row, col));    
    }    
    
    // ============================================= Buttons
    
    public void buttonPressed(Button button)
    {
    }
    
    class ButtonWatcher
        implements ActionListener {
        
        public void actionPerformed(ActionEvent evt)
        {
            buttonPressed((Button)evt.getSource());
        }
    }
    
    public static void setLabel(Button button, String text)
    {
        if(viewReady)
            button.setLabel(text);
    }
    
    public void setBounds(Button button, int x, int y, 
                          int w, int h)
    {
        button.setBounds(x, y, w, h);
    }
    
    public void setLocation(Button button, int x, int y)
    {
        button.setLocation(x, y);
    }
    
    public void setSize(Button button, int w, int h)
    {
        button.setSize(w, h);
    }
    
    public Button getButton(String label, 
                            int x, int y, int w, int h)
    {
        Button button = new Button(label);
        button.setLocation(x, y);
        button.setSize(w, h);
        return button;
    }
    
    public Button getButton(String label, int x, int y)
    {
        return getButton(label, x, y, 60, 25);
    }
    
    public Button getButton(String label)
    {
        return getButton(label, 0, 0);
    }
    
    public void addButton(Button button)
    {
        button.addActionListener(buttonWatcher);    
        panel.addButton(button);
    }
    
    public void addButton(Button button, int pos)
    {
        button.addActionListener(buttonWatcher);    
        panel.addButton(button, pos);
    }
    
    // ============================================= Labels
    
    public static void setLabel(Label label, String text)
    {
        if(viewReady)    
            label.setText(text);
    }
    
    public void setBounds(Label label, int x, int y, 
                          int w, int h)
    {
        label.setBounds(x, y, w, h);
    }
    
    public void setLocation(Label label, int x, int y)
    {
        label.setLocation(x, y);
    }
    
    public void setSize(Label label, int w, int h)
    {
        label.setSize(w, h);
    }
    
    public static Label getLabel(String label, 
                          int x, int y, 
                          int w, int h, int align)
    {
        Label label2 = new Label(label, align);
        label2.setLocation(x, y);
        label2.setSize(w, h);
        return label2;
    }
    
    public Label getLabel(String label, 
                          int x, int y, 
                          int w, int h)
    {
        return getLabel(label, x, y, w, h, Left);
    }
    
    public Label getLabel(String label, 
                          int x, int y, int align)
    {
        return getLabel(label, x, y, 60, 25, align);
    }
    
    
    public Label getLabel(String label, int x, int y)
    {
        return getLabel(label, x, y, Left);
    }
    
    public Label getLabel(String label, int align)
    {
        return getLabel(label, 0, 0, align);
    }
    
    public Label getLabel(String label)
    {
        return getLabel(label, Left);
    }
    
    public void addLabel(Label label)
    {
        panel.addLabel(label, Left);
    }
    
    public void addLabel(Label label, int pos)
    {
        panel.addLabel(label, pos);
    }
        
    // ============================================= Buffering
    
    public void toBuffer(int w, int h)
    {        
        Stroke stroke = pDC.getStroke();
        Paint paint   = pDC.getPaint();
        Color color   = pDC.getColor();
        buffer = createImage(w, h);        
        pDC = (Graphics2D)buffer.getGraphics();
        pDC.setStroke(stroke);
        pDC.setPaint(paint);
        pDC.setColor(color);
        pDC.clearRect(0, 0, w, h);        
        isBuffered = true;
    }
    
    public void toBuffer()
    {       
        toBuffer(w, h);
    }
    
    public Image getBuffer()
    {
        return buffer;
    }
    
    public void toBuffer(Image buffer)
    {
        pDC = (Graphics2D)buffer.getGraphics();
        isBuffered = true;    
    }
    
    public void toScreen(boolean keep)
    {
        if(pDC != pDC2 && !keep)
            pDC.dispose();
        pDC = pDC2;
        redraw();
        isBuffered = false;
    }
    
    public void toScreen()
    {
        toScreen(false);
    }
        
    public void drawBuffer(int x, int y)
    {
        if(isBuffered)
            pDC2.drawImage(buffer, x, y, this);
    }
    
    public void drawBuffer()
    {
        drawBuffer(0, 0);
    }
    
    public void clearRect(int x, int y, int w, int h)
    {
        Paint oldPaint = pDC.getPaint();
        pDC.setColor(Color.white);
        pDC.fillRect(0, 0, w, h);
        pDC.setPaint(oldPaint);
    }
    
    public void clearRect()
    {
        clearRect(0, 0, w, h);
    }
       
    // ============================================= Numbers           
    
    public boolean isNumeric(String data)
    {
        try {
            Double.parseDouble(data);
            return true;
        }
        catch(NumberFormatException e) {
            return false;
        }    
    }       
    
    public boolean isNumeric(String[] data)
    {
        for(int i = 0; i < data.length ; i++)
            if(!isNumeric(data[i]))
                return false;
        return true;
    }
    
    public boolean isDouble(String string)
    {
        if(!isNumeric(string))
            return false;
        return string.indexOf('.') > -1 || 
               string.indexOf('e') > -1 ||
               string.indexOf('E') > -1;
    }
        
    public boolean isInt(String string)
    {
        double number;
        try {
            Integer.parseInt(string);
            return true;            
        }
        catch(NumberFormatException e) {
            return false;
        }
    } 
    
    public boolean isIntegral(String string)
    {
        try {
            double number = Double.parseDouble(string);
            return number == (int)number;
        }
        catch(NumberFormatException e) {
            return false;
        }
    }        
    
    public double getDouble(String string)
    {
        try {
            return Double.parseDouble(string);
        }
        catch(NumberFormatException e) {
            error("Wrong getDouble argument");        
            return Double.NaN;
        }
    }
    
    public int getInt(String string)
    {
        try {
            return (int)Double.parseDouble(string);
        }
        catch(NumberFormatException e) {
            error("Wrong getInt argument");
            return Integer.MIN_VALUE;
        }
    }    
    
    // ============================================= Streams
        
    public void close(Stream stream)
    {
        stream.close();
    }
    
    public Stream open(String name, boolean forOutput)
    {
        if(forOutput) {
            try {
                return new Output$(name);
            }
            catch(IOException e) {
            }
        } else {
            try {
                return new Input$(name);
            }
            catch(FileNotFoundException e) {
                showMsg(name + " not found");
            }
        }
        return null;
    }
    
    public Stream open(String name)
    {
        return open(name, false);
    }        
        
    public String read(Stream stream)
    {
        if(!(stream instanceof Input$))
            return null;
        return ((Input$)stream).read();
    }
    
    public boolean isEOL(String string)
    {
        return string.equals("");
    }   
    
    public Stream reset(Stream stream)
    {
        stream.close();
        try {
            if(stream instanceof Input$)
                return ((Input$)stream).reset();
        }
        catch(FileNotFoundException e) {
        }
        return null;
    }         
            
    public void write(Stream out, String string)
    {
        if(!(out instanceof Output$))
            return;
        ((Output$)out).write(string);
    }
        
    public void writeEOL(Stream out)
    {
        if(!(out instanceof Output$))
            return;
        ((Output$)out).write("");
    }
    
    // ============================================= Debugger
        
    private static boolean debuggerStopped = false;
    
    public static void setNotDebugged()
    {
       isDebugged = false;
    }
    
    public static void check()
    {
        if(!isDebugged) {
            new Debugger(view, dbgLoc, dbgSize);
            isDebugged = true;
            view.requestFocus();
            panel.requestFocus();
        }
    }    
    
    public static void dbg(Object one, Object two)
    {
        dbg(one + "  " + two);
    }
    
    public static void dbg(String msg)
    {  
        if(debuggerStopped)
            return;
        check();
        Debugger.toFrame(msg);
    }

    public static void dbg(char val)
    {
        dbg("" + val);
    }    
    
    public static void dbg(int val)
    {
        dbg("" + val);
        panel.requestFocus();
    }
    
    public static void dbg(double val)
    {
        dbg("" + val);
    }
    
    public static void dbg(boolean val)
    {
        dbg("" + val);
    }
    
    public static void dbg(Object obj)
    {
        if(debuggerStopped)
            return;       
        check();
        Debugger.toFrame(obj);
    }
    
    public static void dbg()
    {
        dbg("");
    }
    
    public static void dbgOff()
    {
        if(debuggerStopped)
            return;    
        Debugger.off();
    }
    
    public static void dbgAssert(String what, boolean isTrue)
    {
        if(debuggerStopped)
            return;    
        check();
        Debugger.assert(what, isTrue);
    }
     
    public static void dbgClear()
    {
        if(debuggerStopped)
            return;    
        check();
        Debugger.clear();
    }   
    
    public static void dbgOn()
    {
        if(debuggerStopped)
            return;    
       Debugger.on();
    }       
    
    public static void dbgFont(int size)
    {
        if(debuggerStopped)
            return;
        Debugger.setFontSize(size);
    }
    
    public static void dbgSize(int w, int h)
    {
        if(debuggerStopped)
            return; 
       setNotDebugged();
       dbgSize = new Dimension(w, h);
    }
    
    public static void dbgLoc(int x, int y)
    {
        if(debuggerStopped)
            return;    
       dbgLoc = new Point(x, y);
    }
    
    public static void dbgLimit(int limit)
    {
        if(debuggerStopped)
            return;    
        Debugger.setLimit(limit);
    }       
    
    public static void dbgStop()
    {
        debuggerStopped = true;
    }


   // ============================================= Monitor
   
   public Monitor getMonitor(boolean state)
   {
       return new Monitor(state);
   }
   
   public Monitor getMonitor()
   {
       return getMonitor(false);
   }   
    
    public void mWait(Monitor m)
    {    
        m.jbWait();
    }
    
    public void mPause(Monitor m)
    {
        m.jbPause();
    }

    public void mNotify(Monitor m)
    {
        m.jbNotify();
    }
    
    public void mNotifyAll(Monitor m)
    {
        m.jbNotifyAll();
    }    

    public void mWaitBreak(Monitor m)
        throws InterruptedException
    {
        m.jbWaitBreak();
    }
}

// Not implemented

 /*      
    public void startRun(final Class runClass)
    {
        class Runner
            extends Thread {
            
            public Runner()
            {
                this.start();
            }
            
            public void run()  
            {   
                Object runner = null;
                try {       
                    runner = runClass.newInstance();
                    Class nullParam[] = new Class[] { };
                    Method method = 
                        runClass.getDeclaredMethod(
                                    "run", nullParam
                                 );
                    Object[] nullArgs = new Object[] { };
                    method.invoke(runner, nullArgs);
                }
                catch(Exception e) {
                    error(runClass + " is not external!");
                }                
            }
        }
        
        new Runner();
    }
    */
    