//*** Klasa String$

package janb.view;

import java.awt.*;
import java.awt.geom.*;
import java.awt.font.*;

public
class String$ 
    extends Figure {    
    
    private String string;
    private Rectangle2D bounds;
    private TextLayout layout;
    
    public String$(int x, int y, String string, Graphics gDC)
    {
        super(x, y, -1, -1, gDC);
        this.string = string;
        bounds = getBounds(string, getFont(), gDC);
        setSize(
            (int)bounds.getWidth(),
            (int)bounds.getHeight()
        );
    }
    
    public String getString()
    {
        return string;
    }
        
    public static Rectangle2D getBounds(
                                  String string, 
                                  Font font, 
                                  Graphics gDC
                              )
    {
        Graphics2D pDC = (Graphics2D)gDC;
        FontRenderContext frc = 
            pDC.getFontRenderContext();
        TextLayout layout = 
            new TextLayout(string, font, frc);
        return new TextLayout(string, font, frc).
               getBounds();
    }                
    
    public static TextLayout getLayout(
                                 String string, 
                                 Font font,
                                 Graphics gDC)
    {     
        Graphics2D pDC = (Graphics2D)gDC;   
        FontRenderContext frc = 
            pDC.getFontRenderContext();
        return new TextLayout(string, font, frc);
    }   

    public static Metrics getMetrics(String string,
                                     Font font,
                                     Graphics2D gDC)
    {
        TextLayout layout = getLayout(string, font, gDC);
        return new Metrics(layout);
    }
               
    public void draw(Graphics2D gDC)
    {
        Paint oldPaint = gDC.getPaint();
        Font oldFont = gDC.getFont();
        gDC.setPaint(getPaint());
        gDC.setFont(getFont());

        int xL = getX(),
            yL = getY();
        TextLayout layout = 
            getLayout(string, getFont(), gDC);
        Rectangle2D bounds = layout.getBounds();
        float xB = (float)bounds.getX(),
              yB = (float)bounds.getY();
        layout.draw(gDC, -xB + xL, -yB + yL);
        gDC.setFont(oldFont);
        gDC.setPaint(oldPaint);
    }
}