//*** Klasa Monitor

package janb.view;

import java.util.*;

public
class Monitor {

    private boolean monitorFlag;
    private Object monitor = new Object();
    private static Object cloneLock = new Object();
    private static Vector monitors = new Vector();

    public Monitor(boolean flag)
    {
        monitorFlag = flag;
        synchronized(cloneLock) {
            monitors.add(this);
        }
    }

    public void jbWaitBreak()
        throws InterruptedException
    {
        synchronized(monitor) {
            while(!monitorFlag)
                monitor.wait();
            monitorFlag = false;
        }
    }

    public void jbNotify()
    {
        synchronized(monitor) {
            monitorFlag = true;
            monitor.notify();
        }
    }
    
    public void jbNotifyAll()
    {
        Vector clone;
        synchronized(cloneLock) {
            clone = (Vector)monitors.clone();
        }
        int count = clone.size();
        for(int i = 0; i < count ; i++) {
            Object object = clone.get(i);
            Monitor monitor = ((Monitor)object);
            synchronized(monitor.monitor) {
                monitor.monitorFlag = true;
                monitor.monitor.notify();
            }
        }
    }
    

        // wersja nieprzerywalna, zbdne try
    public void jbWait()
    {
        synchronized(monitor) {
            while(!monitorFlag) {
                try {
                    monitor.wait();
                }
                catch(InterruptedException e) {
                }
            }
            monitorFlag = false;
        }
    }

    public void jbPause()
    {
        synchronized(monitor) {
        }
    }
}