//*** Klasa Input$

package janb.view;

import java.io.*;

public
class Input$ 
    extends Stream {

    private String name;
    private FileReader reader;
    private StreamTokenizer inp;
    private int what;
    private boolean tokenReady = false;
    private String token;
    
    static final
    int EOF    = StreamTokenizer.TT_EOF,
        WORD   = StreamTokenizer.TT_WORD,
        NUMBER = StreamTokenizer.TT_NUMBER,
        EOL    = StreamTokenizer.TT_EOL;
        
    public Input$(String name)
        throws FileNotFoundException
    {
        this.name = name;
        reset();
    }
    
    public Stream reset()
        throws FileNotFoundException
    {      
        reader = new FileReader(name);
        inp = new StreamTokenizer(reader);
        inp.eolIsSignificant(true);
        inp.quoteChar('"');
        inp.parseNumbers();
        return this;        
    }
    
    public String read()
    {
        if(tokenReady && what == WORD) {
            tokenReady = false;
            return token;
        }

        if(!tokenReady) {
            try {
                what = inp.nextToken();
            }
            catch(IOException e) {
                what = EOF;
            }
        }
        tokenReady = false;
        
        switch(what) {            
            case EOF:             
                try {
                    reader.close();
                }
                catch(IOException e) {
                }
                return null;                    
            case EOL:                    
                return "";
            case NUMBER:
                String result = inp.nval + "";
                try {
                    what = inp.nextToken();       
                    tokenReady = true;
                }
                catch(IOException e) {
                    what = EOF;
                }
                
                String tail;
                if(what == WORD && 
                   (tail = inp.sval).charAt(0) == 'e' &&
                   tail.length() > 1 
                    ) {
                    tail = tail.substring(1);
                    try {
                        Integer.parseInt(tail);
                        tokenReady = false;
                        result += 'e' + tail;
                    }
                    catch(NumberFormatException e) {
                        what = WORD;
                        token = 'e' + tail;
                    }
                }
                return result;
            case WORD:
                return inp.sval;
            case '"':
                return inp.sval;
            default:
                return (char)what + " ";
        }
    }
           
    public void close()
    {
        try {
            reader.close();
        }
        catch(IOException e) {
        }
    }
}