//*** Klasa Figure

package janb.view;

import java.awt.*;

public abstract 
class Figure
    implements Names, Drawable {
    
    protected static int defWidth = 100;
    protected static Paint defPaint = Color.red;
    protected static Font defFont = 
                         Names.SerifBoldItalic30;
    protected static Stroke defStroke = Names.Stroke_1;
    protected static int defFill = Names.Ring;
    private int x, y, w, h;
    private Paint paint;
    private Stroke stroke;
    private Font font;
    private int fill;
        
    public Figure(int x, int y, int w, int h, Graphics gDC)
    {
        Graphics2D pDC = (Graphics2D)gDC;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;        
        if(gDC != null) {
            paint  = pDC.getPaint();
            stroke = pDC.getStroke();
            font   = pDC.getFont();
        } else {
            paint  = defPaint;
            stroke = defStroke;
            font   = defFont;
        }
        fill = defFill;
    }
    
    abstract public void draw(Graphics2D gDC);
    
    protected void setGradient(Graphics2D pDC, 
                               int x, int y, int w, int h)
    {
        Paint paint = pDC.getPaint();
        Color colorA = null, colorZ = null;    
        if(paint instanceof GradientPaint) {
            GradientPaint grad = 
               (GradientPaint)paint;
            colorA = grad.getColor1();
            colorZ = grad.getColor2();
            grad = new GradientPaint(
                       x, y,
                       colorA,
                       x+w, y+h,
                       colorZ
                   ); 
            pDC.setPaint(grad);
        }    
    }           
                  
    public int getX()
    {
        return x;
    }
    
    public int getY()
    {
        return y;
    }
    
    public int getWidth()
    {
        return w;
    }
    
    public int getHeight()
    {
        return h;
    }    
        
    public Paint getPaint()
    {
        return paint;
    }
    
    public Stroke getStroke()
    {
        return stroke;
    }
        
    public Font getFont()
    {
        return font;
    }    
    
    public int getFill()
    {
        return fill;
    }        
    
    public void setXY(int x, int y)
    {
        this.x = x;
        this.y = y;
    }
       
    public void setSize(int w, int h)
    {
        this.w = w;
        this.h = h;
    }
    
     public void setPaint(Paint paint)
    {
        this.paint = paint;
    }
    
    public void setStroke(Stroke stroke)
    {
        this.stroke = stroke;
    }
    
    public void setFont(Font font)
    {
        this.font = font;
    }    
    
    public void setFill(int fill)
    {
        this.fill = fill;
    }
}