//*** Klasa Diamond

package janb.view;

import java.awt.*;

public
class Diamond 
    extends Figure {
    
    private Polygon polyOuter, polyDraw, polyInner;
                    
    private Polygon makePolygon(int x, int y, int w, int h)
    {
        Polygon polygon = new Polygon();
        int w2 = w/2,
            h2 = h/2;
        polygon.addPoint(x+w2, y);
        polygon.addPoint(x+w, y+h2);
        polygon.addPoint(x+w2, y+h);
        polygon.addPoint(x, y+h2);    
        return polygon;
    }   
    
    public void makePolygons()
    {
        int x = getX(),
            y = getY(),
            w = getWidth(),
            h = getHeight();
        int ll = (int)
                 (((BasicStroke)getStroke()).getLineWidth()),
            l2 = ll/2;
        polyOuter = makePolygon(x, y, w, h);
        polyDraw  = makePolygon(x+l2, y+l2, w-ll, h-ll);
        polyInner = makePolygon(x+ll, y+ll, w-2*ll, h-2*ll);    
    }                 
       
    public Diamond(int x, int y, int w, int h, Graphics gDC)
    {
        super(x, y, w, h, gDC); 
        makePolygons();
    }
       
    public Diamond(int x, int y, int w, int h)
    {
        this(x, y, w, h, null);    
    }
    
    public Diamond(int x, int y, int d, Graphics gDC)
    {
        this(x, y, d, d, gDC);
    }    
    
    public Diamond(int x, int y, int s)
    {
        this(x, y, s, s, null);
    }
       
    public Diamond(int x, int y)
    {
        this(x, y, defWidth);
    }
    
    public void draw(Graphics2D gDC)
    {
        Paint oldPaint = gDC.getPaint();
        gDC.setPaint(getPaint());
        Stroke oldStroke = gDC.getStroke();
        int x = getX(),
            y = getY(),
            w = getWidth(),
            h = getHeight(); 
        int what;
        switch(what = getFill()) {
            case Thin:    // Thin
                gDC.setStroke(Stroke_1);
                gDC.drawPolygon(polyDraw);
                break;            
            case Line:    // Line
                setGradient(gDC, x, y, w, h);
                gDC.setStroke(Stroke_1);
                gDC.drawPolygon(polyDraw);
                // break;  (sic!)
            case Ring:    // Ring     
                setGradient(gDC, x, y, w, h);
                gDC.setStroke(getStroke());            
                gDC.drawPolygon(polyDraw);
                gDC.setColor(Color.black);
                gDC.setStroke(new BasicStroke(1));
                gDC.drawPolygon(polyOuter);
                gDC.drawPolygon(polyInner);
                break;
            case Full:    // Full  
                setGradient(gDC, x, y, w, h);            
                gDC.fillPolygon(polyOuter);
                gDC.setStroke(new BasicStroke(1));
                gDC.setColor(Color.black);
                gDC.drawPolygon(polyOuter);
        }            
        gDC.setStroke(oldStroke);
        gDC.setPaint(oldPaint);
    }
    
    public void setXY(int x, int y)
    {
        super.setXY(x, y);
        makePolygons();
    }
    
    public void setSize(int w, int h)
    {
        super.setSize(w, h);
        makePolygons();
    }
    
    public void setStroke(Stroke stroke)
    {
        super.setStroke(stroke);
        makePolygons();
    }    
}