//*** Klasa Debugger

package janb.view;

import java.awt.*;
import java.awt.event.*;

public
class Debugger 
    extends Frame {

    private static Debugger frame;
    private static Font font =
        new Font("Monospaced", Font.BOLD, 10);
    private static int limit = -1000000;
    private static String NULL = "NULL String";
    private static int tally = 0;

    public static synchronized 
    boolean check()
    {
        if(limit == 0) {
            textArea.append("\nLimit reached!\n");
            limit = 1;
        }
        if(limit < 0) {
            limit++;
            return true;
        } else
            return false;
    }

    public Font getFont()
    {
        return frame.font;
    }

    class MyTextArea extends TextArea {

        public MyTextArea(String header)
        {
            super(header);
        }
        
        public synchronized
        void paint(Graphics gDC)
        {
            gDC.setFont(frame.getFont());
        }
    }

    String header = "Debugger\n========\n";
    static MyTextArea textArea;
    static boolean opened = false,
                   active = false;
    int xLoc = 320, yLoc = 0;
    private View view;
   
    public Debugger(View view, Point loc, Dimension size)
    {
        this(loc.x, loc.y, size.width, size.height);
        this.view = view;
    }
    
    public Debugger(int x, int y, int width, int height)
    {
        super("Debugger");
        frame = this;
        setLocation(x, y);
        opened = true;
        active = true;
        setSize(width, height);
        textArea = new MyTextArea(header);
        add(textArea, BorderLayout.CENTER);
        addWindowListener(
            new WindowAdapter() {
                public void
                windowClosing(WindowEvent evt)
                {
                    setVisible(false);
                    dispose();
                    opened = false;
                    view.setNotDebugged();
                }
            }
        );
        setVisible(true);
    }
    
    public static synchronized
    void toFrame(String string)
    {
        if(active && check()) {
            if(string != null)
                tally += string.length() + 1;
            else
                tally += NULL.length() + 1;
            if(tally > 50000) {
                String msg = "Window FORCEFULLY cleared!\n";
                textArea.setText(msg);
                tally = msg.length() + string.length() + 1;
            }
            if(string == null)
                string = NULL;
            textArea.append(string + '\n');            
        }
    }
    
    public static synchronized
    void toFrame()
    {
        toFrame("");
    }  
      
    public static synchronized
    void toFrame(int num)
    {
        toFrame("" + num);
    }
    
    public static synchronized    
    void toFrame(boolean bool)
    {
        toFrame("" + bool);
    }
    
    public static synchronized
    void toFrame(double num)
    {
        toFrame("" + num);
    }
    
    public static synchronized
    void toFrame(Object object)
    {
        if(active && check()) {
            if(object != null)
                toFrame(object.toString());
            else
                toFrame("NULL Object");
        }
    }
    
    public static synchronized
    void assert(String what, boolean isTrue)
    {
        if(what == null)
            what = "";
        if(active && !isTrue)
            toFrame("Assertion \"" + what + "\" failed\n");
    }
    
    public static synchronized 
    void on()
    {
        if(opened)
            active = true;
    }
    
    public static synchronized 
    void off()
    {
        active = false;
    }
    
    public static synchronized 
    void setLoc(int x, int y)
    {
        if(active)
            frame.setLocation(x, y);
    }
    
    public static synchronized 
    void setFontSize(int size)
    {
        //if(active)
            font = new Font(
                       "Monospaced", Font.BOLD, size
                   );
    }
    
    public static synchronized 
    void clear()
    {
        if(active)
            textArea.setText("Window cleared!\n");
    }
    
    public static synchronized 
    void setLimit(int limit)
    {
        if(active) {
            if(limit <= 0)
                return;
            Debugger.limit = -limit;
        }
    }
}