/*
 * CustomerServiceImpl.java
 * 
 * Created on 25/05/2007, 20:20:15
 * 
 * Aby zmieni ten szablon, nalezy z menu Tools wybra opcj Template Manager
 * i otworzy ten szablon w edytorze.
 */

package com.wakaleo.jpt.customerws;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author john
 */
public class CustomerServiceImpl implements CustomerService  {

    private static Customer[] CUSTOMERS = {
        new Customer("1", "John", "Doe", 
                     new Address("1","1 main street", "Kelburn","Wellington", null , "New Zealand", "6000"),
                     new Address("2","1 main street", "Johnsonville","Wellington", null , "New Zealand", "6000")),
        new Customer("2", "Jane", "Doe", 
                     new Address("3","10 high street", "Kelburn","Wellington", null , "New Zealand", "6000"),
                     new Address("4","1 high street", "Johnsonville","Wellington", null , "New Zealand", "6000")),
        new Customer("3", "Jane", "Smith", 
                     new Address("5","20 long street", "Kelburn","Wellington", null , "New Zealand", "6000"),
                     new Address("6","1 long street", "Johnsonville","Wellington", null , "New Zealand", "6000")),
        new Customer("4", "Jack", "Smith", 
                     new Address("7","20 main street", "Kelburn","Wellington", null , "New Zealand", "6000"),
                     new Address("8","10 main street", "Johnsonville","Wellington", null , "New Zealand", "6000")),
        new Customer("5", "Jack", "Sparrow", 
                     new Address("9","20 main street", "Kelburn","Wellington", null , "New Zealand", "6000"),
                     new Address("10","10 main street", "Johnsonville","Wellington", null , "New Zealand", "6000")),
        new Customer("6", "Jack", "London", 
                     new Address("11","20 main street", "Kelburn","Wellington", null , "New Zealand", "6000"),
                     new Address("12","10 main street", "Johnsonville","Wellington", null , "New Zealand", "6000")),
        new Customer("7", "John", "Smith", 
                     new Address("13","20 main street", "Kelburn","Wellington", null , "New Zealand", "6000"),
                     new Address("14","10 main street", "Johnsonville","Wellington", null , "New Zealand", "6000")),
        new Customer("8", "Jake", "Smith", 
                     new Address("15","20 main street", "Kelburn","Wellington", null , "New Zealand", "6000"),
                     new Address("16","10 main street", "Johnsonville","Wellington", null , "New Zealand", "6000")),
        new Customer("9", "Jack", "Smart", 
                     new Address("11","20 main street", "Kelburn","Wellington", null , "New Zealand", "6000"),
                     new Address("12","10 main street", "Johnsonville","Wellington", null , "New Zealand", "6000")),
        new Customer("10", "James", "Smart", 
                     new Address("13","20 main street", "Kelburn","Wellington", null , "New Zealand", "6000"),
                     new Address("14","10 main street", "Johnsonville","Wellington", null , "New Zealand", "6000")),
        new Customer("11", "Jake", "Smart", 
                     new Address("15","20 main street", "Kelburn","Wellington", null , "New Zealand", "6000"),
                     new Address("16","10 main street", "Johnsonville","Wellington", null , "New Zealand", "6000")),

    };

    public CustomerServiceImpl() {
    }
    
    public Customer findById(String id) {
        for(Customer customer : CUSTOMERS) {
            if (id.equalsIgnoreCase(customer.getId())) {
            	return customer;
            }
        }  
        return null;
    }
    
    public Customer[] findByName(String name) {
        List<Customer> results = new ArrayList<Customer>();
        for(Customer customer : CUSTOMERS) {
            if (name.equalsIgnoreCase(customer.getLastName())) {
                results.add(customer);
            }
        }  
        return results.toArray(new Customer[0]);
    }

    public Customer[] findByHomeCity(String city) {
        List<Customer> results = new ArrayList<Customer>();
        for(Customer customer : CUSTOMERS) {
            if (city.equalsIgnoreCase(customer.getHomeAddress().getCity())) {
                results.add(customer);
            }
        }  
        return results.toArray(new Customer[0]);
    }    

}
 