package com.wakaleo.jpt.taxcalculator.impl;

import static org.junit.Assert.assertEquals;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

import com.wakaleo.jpt.taxcalculator.InvalidYearException;
import com.wakaleo.jpt.taxcalculator.TaxCalculator;
import com.wakaleo.jpt.taxcalculator.impl.TaxCalculatorImpl;

@RunWith(Parameterized.class)
public class TaxCalculationTest {
    @Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][] {
        /* Dochd Rok Podatek*/
        { 0.00, 2006, 0.00 }, { 10000.00, 2006, 1950.00 },
        { 20000.00, 2006, 3900.00 }, { 38000.00, 2006, 7410.00 },
        { 38001.00, 2006, 7410.33 }, { 40000.00, 2006, 8070.00 },
        { 60000.00, 2006, 14670.00 }, { 100000.00, 2006, 30270.00 }, });
    }

    private double income;
    private int year;
    private double expectedTax;

    public TaxCalculationTest(double income, int year, double expectedTax) {
        this.income = income;
        this.year = year;
        this.expectedTax = expectedTax;
    }

    @Test
    public void shouldCalculateCorrectTax() throws InvalidYearException {
        TaxCalculator calculator = new TaxCalculatorImpl();
        double calculatedTax = calculator.calculateIncomeTax(income, year);
        assertEquals(expectedTax, calculatedTax, 0.0);
    }
}